/*
 * Decompiled with CFR 0.152.
 */
package adams.core.tags;

import adams.core.Variables;
import adams.core.base.BaseKeyValuePair;
import adams.core.tags.TagHandler;
import adams.flow.core.Actor;
import adams.gui.flow.tree.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TagProcessorHelper {
    public static boolean hasTag(Object obj, String tag) {
        if (!(obj instanceof TagHandler)) {
            return false;
        }
        List<BaseKeyValuePair> tags = ((TagHandler)obj).getAllTags();
        for (BaseKeyValuePair t : tags) {
            if (!t.getPairKey().equals(tag)) continue;
            return true;
        }
        return false;
    }

    protected static String getTagValue(Object obj, String tag, Variables vars) {
        if (!(obj instanceof TagHandler)) {
            return null;
        }
        List<BaseKeyValuePair> tags = ((TagHandler)obj).getAllTags();
        for (BaseKeyValuePair t : tags) {
            if (!t.getPairKey().equals(tag)) continue;
            String result = t.getPairValue();
            if (vars != null && result.contains("@{") && (result = vars.expand(result)).contains("@{")) {
                result = null;
            }
            return result;
        }
        return null;
    }

    public static String getTagString(Object obj, String tag, String defValue) {
        return TagProcessorHelper.getTagString(obj, tag, defValue, null);
    }

    public static String getTagString(Object obj, String tag, String defValue, Variables vars) {
        String result = TagProcessorHelper.getTagValue(obj, tag, vars);
        if (result == null) {
            result = defValue;
        }
        return result;
    }

    public static boolean getTagBoolean(Object obj, String tag, boolean defValue) {
        return TagProcessorHelper.getTagBoolean(obj, tag, defValue, null);
    }

    public static boolean getTagBoolean(Object obj, String tag, boolean defValue, Variables vars) {
        boolean result = defValue;
        String value = TagProcessorHelper.getTagValue(obj, tag, vars);
        if (value != null) {
            try {
                result = Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                result = defValue;
            }
        }
        return result;
    }

    public static byte getTagByte(Object obj, String tag, byte defValue) {
        return TagProcessorHelper.getTagByte(obj, tag, defValue, null);
    }

    public static byte getTagByte(Object obj, String tag, byte defValue, Variables vars) {
        byte result = defValue;
        String value = TagProcessorHelper.getTagValue(obj, tag, vars);
        if (value != null) {
            try {
                result = Byte.parseByte(value);
            }
            catch (Exception e) {
                result = defValue;
            }
        }
        return result;
    }

    public static int getTagInt(Object obj, String tag, int defValue) {
        return TagProcessorHelper.getTagInt(obj, tag, defValue, null);
    }

    public static int getTagInt(Object obj, String tag, int defValue, Variables vars) {
        int result = defValue;
        String value = TagProcessorHelper.getTagValue(obj, tag, vars);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (Exception e) {
                result = defValue;
            }
        }
        return result;
    }

    public static long getTagLong(Object obj, String tag, long defValue) {
        return TagProcessorHelper.getTagLong(obj, tag, defValue, null);
    }

    public static long getTagLong(Object obj, String tag, long defValue, Variables vars) {
        long result = defValue;
        String value = TagProcessorHelper.getTagValue(obj, tag, vars);
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (Exception e) {
                result = defValue;
            }
        }
        return result;
    }

    public static float getTagFloat(Object obj, String tag, float defValue) {
        return TagProcessorHelper.getTagFloat(obj, tag, defValue, null);
    }

    public static float getTagFloat(Object obj, String tag, float defValue, Variables vars) {
        float result = defValue;
        String value = TagProcessorHelper.getTagValue(obj, tag, vars);
        if (value != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (Exception e) {
                result = defValue;
            }
        }
        return result;
    }

    public static double getTagDouble(Object obj, String tag, double defValue) {
        return TagProcessorHelper.getTagDouble(obj, tag, defValue, null);
    }

    public static double getTagDouble(Object obj, String tag, double defValue, Variables vars) {
        double result = defValue;
        String value = TagProcessorHelper.getTagValue(obj, tag, vars);
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (Exception e) {
                result = defValue;
            }
        }
        return result;
    }

    public static List<BaseKeyValuePair> getAllTags(TagHandler handler) {
        return new ArrayList<BaseKeyValuePair>(handler.getAllTags());
    }

    protected static void addToMap(Map<String, BaseKeyValuePair> map, List<BaseKeyValuePair> tags, boolean override) {
        TagProcessorHelper.addToMap(map, tags.toArray(new BaseKeyValuePair[tags.size()]), override);
    }

    protected static void addToMap(Map<String, BaseKeyValuePair> map, BaseKeyValuePair[] tags, boolean override) {
        for (BaseKeyValuePair tag : tags) {
            if (map.containsKey(tag.getPairValue()) && override) {
                map.put(tag.getPairKey(), tag);
                continue;
            }
            if (map.containsKey(tag.getPairKey())) continue;
            map.put(tag.getPairKey(), tag);
        }
    }

    public static List<BaseKeyValuePair> getAllTags(Actor actor, boolean traverse) {
        HashMap<String, BaseKeyValuePair> tags = new HashMap<String, BaseKeyValuePair>();
        if (actor instanceof TagHandler) {
            TagProcessorHelper.addToMap(tags, ((TagHandler)actor).getTags(), false);
        }
        if (traverse) {
            for (Actor parent = actor.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof TagHandler)) continue;
                TagProcessorHelper.addToMap(tags, ((TagHandler)parent).getAllTags(), false);
                break;
            }
        }
        ArrayList<BaseKeyValuePair> result = new ArrayList<BaseKeyValuePair>(tags.values());
        return result;
    }

    public static List<BaseKeyValuePair> getAllTags(Node node, boolean traverse) {
        HashMap<String, BaseKeyValuePair> tags = new HashMap<String, BaseKeyValuePair>();
        if (node.getActor() instanceof TagHandler) {
            TagProcessorHelper.addToMap(tags, ((TagHandler)node.getActor()).getTags(), false);
        }
        if (traverse) {
            for (Node parent = (Node)node.getParent(); parent != null; parent = (Node)parent.getParent()) {
                if (!(parent.getActor() instanceof TagHandler)) continue;
                TagProcessorHelper.addToMap(tags, TagProcessorHelper.getAllTags(parent, traverse), false);
                break;
            }
        }
        ArrayList<BaseKeyValuePair> result = new ArrayList<BaseKeyValuePair>(tags.values());
        return result;
    }
}

