/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.Utils;
import adams.flow.control.Sequence;
import adams.flow.control.SubProcess;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.InactiveActor;
import adams.flow.processor.AbstractModifyingProcessor;
import adams.flow.processor.CleanUpProcessor;
import adams.flow.sink.Null;
import adams.flow.source.SequenceSource;
import adams.flow.standalone.Standalones;
import adams.flow.transformer.PassThrough;

public class ReactivateActors
extends AbstractModifyingProcessor
implements CleanUpProcessor {
    private static final long serialVersionUID = -8658024993875114313L;

    public String globalInfo() {
        return "Activates all actors implementing the " + Utils.classToString(InactiveActor.class) + ". If an actor cannot be removed, it gets disabled.";
    }

    protected Actor transferName(Actor source, Actor target) {
        target.setName(source.getName());
        return target;
    }

    protected void activate(ActorHandler handler, int index) {
        Actor actor = handler.get(index);
        if (actor instanceof ActorHandler) {
            ActorHandler subHandler = (ActorHandler)actor;
            if (subHandler.size() == 0) {
                if (ActorUtils.isStandalone((Actor)subHandler)) {
                    handler.set(index, this.transferName((Actor)subHandler, (Actor)new adams.flow.standalone.Null()));
                } else if (ActorUtils.isSource((Actor)subHandler)) {
                    handler.set(index, this.transferName((Actor)subHandler, (Actor)new adams.flow.source.Null()));
                } else if (ActorUtils.isTransformer((Actor)subHandler)) {
                    handler.set(index, this.transferName((Actor)subHandler, (Actor)new PassThrough()));
                } else if (ActorUtils.isSink((Actor)subHandler)) {
                    handler.set(index, this.transferName((Actor)subHandler, (Actor)new Null()));
                } else {
                    this.getLogger().warning("Unknown actor type: " + Utils.classToString((Object)subHandler));
                }
            } else if (subHandler.size() == 1) {
                handler.set(index, subHandler.get(0));
            } else {
                Actor[] actors = new Actor[subHandler.size()];
                for (int i = 0; i < subHandler.size(); ++i) {
                    actors[i] = subHandler.get(i);
                }
                if (ActorUtils.isStandalone((Actor)subHandler)) {
                    Standalones standalones = new Standalones();
                    standalones.setName(subHandler.getName());
                    standalones.setActors(actors);
                    handler.set(index, (Actor)standalones);
                } else if (ActorUtils.isSource((Actor)subHandler)) {
                    SequenceSource seqsource = new SequenceSource();
                    seqsource.setName(subHandler.getName());
                    seqsource.setActors(actors);
                    handler.set(index, (Actor)seqsource);
                } else if (ActorUtils.isTransformer((Actor)subHandler)) {
                    SubProcess subproc = new SubProcess();
                    subproc.setName(subHandler.getName());
                    subproc.setActors(actors);
                    handler.set(index, (Actor)subproc);
                } else if (ActorUtils.isSink((Actor)subHandler)) {
                    Sequence sequence = new Sequence();
                    sequence.setName(subHandler.getName());
                    sequence.setActors(actors);
                    handler.set(index, (Actor)sequence);
                } else {
                    this.getLogger().warning("Unknown actor type: " + Utils.classToString((Object)subHandler));
                }
            }
        } else {
            handler.set(index, actor);
        }
    }

    protected void processActor(Actor actor) {
        if (actor instanceof ActorHandler) {
            int i;
            ActorHandler handler = (ActorHandler)actor;
            for (i = 0; i < handler.size(); ++i) {
                if (!(handler.get(i) instanceof InactiveActor)) continue;
                this.activate(handler, i);
                this.m_Modified = true;
            }
            for (i = 0; i < handler.size(); ++i) {
                this.processActor(handler.get(i));
            }
        }
    }
}

