/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.Utils;
import adams.core.logging.LoggingLevel;
import adams.flow.control.AbstractControlActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.MutableActorHandler;
import adams.flow.standalone.StandaloneGroup;
import adams.flow.standalone.StandaloneGroupItem;
import nz.ac.waikato.cms.locator.ClassLocator;

public abstract class AbstractMutableStandaloneGroupItem<T extends Actor>
extends AbstractControlActor
implements MutableActorHandler,
StandaloneGroupItem<T> {
    private static final long serialVersionUID = -2130921331341838430L;
    protected MutableActorHandler m_Actors;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actor", "actors", (Object)new Actor[0]);
    }

    protected void initialize() {
        super.initialize();
        this.m_Actors = this.newActorHandler();
    }

    protected abstract MutableActorHandler newActorHandler();

    public void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_Actors.setLoggingLevel(value);
    }

    @Override
    public T getEnclosingGroup() {
        if (this.getParent() == null) {
            return null;
        }
        if (this.getParent() instanceof StandaloneGroup) {
            return (T)this.getParent();
        }
        return null;
    }

    public String check() {
        return this.checkSubActors(this.getActors());
    }

    protected String checkSubActor(int index, Actor actor) {
        String result = null;
        Class[] accepted = this.getActorFilter();
        boolean found = false;
        for (Class cls : accepted) {
            if (ClassLocator.isSubclass((Class)cls, actor.getClass())) {
                found = true;
                break;
            }
            if (!ClassLocator.hasInterface((Class)cls, actor.getClass())) continue;
            found = true;
            break;
        }
        if (!found) {
            result = "Actor #" + (index + 1) + " (" + Utils.classToString((Object)actor) + ") is not of type: " + Utils.classesToString((Class[])accepted);
        }
        return result;
    }

    protected String checkSubActors(Actor[] actors) {
        for (int i = 0; i < actors.length; ++i) {
            String msg = this.checkSubActor(i, actors[i]);
            if (msg == null) continue;
            return msg;
        }
        return null;
    }

    public void setActors(Actor[] value) {
        String msg = this.checkSubActors(value);
        if (msg == null) {
            this.m_Actors.removeAll();
            for (Actor actor : value) {
                this.m_Actors.add(actor);
            }
        } else {
            throw new IllegalArgumentException(msg);
        }
        this.reset();
        this.updateParent();
    }

    public Actor[] getActors() {
        Actor[] result = new Actor[this.m_Actors.size()];
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            result[i] = this.m_Actors.get(i);
        }
        return result;
    }

    public abstract String actorsTipText();

    protected void updateParent() {
        this.m_Actors.setName(this.getName());
        this.m_Actors.setParent(null);
        this.m_Actors.setParent(this.getParent());
    }

    public int size() {
        return this.m_Actors.size();
    }

    public Actor get(int index) {
        return this.m_Actors.get(index);
    }

    public String set(int index, Actor actor) {
        String result = this.checkSubActor(index, actor);
        if (result == null) {
            this.m_Actors.set(index, actor);
            this.reset();
            this.updateParent();
        }
        return result;
    }

    public int indexOf(String actor) {
        return this.m_Actors.indexOf(actor);
    }

    public String add(Actor actor) {
        return this.add(this.size(), actor);
    }

    public String add(int index, Actor actor) {
        if (actor == this) {
            throw new IllegalArgumentException("Cannot add itself!");
        }
        String result = this.checkSubActor(index, actor);
        if (result == null) {
            this.m_Actors.add(index, actor);
            this.reset();
            this.updateParent();
        }
        return result;
    }

    public Actor remove(int index) {
        Actor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    public void removeAll() {
        this.m_Actors.removeAll();
        this.reset();
    }

    protected MutableActorHandler getInternalActors() {
        return this.m_Actors;
    }

    protected Class[] getActorFilter() {
        return null;
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        if (this.getActorFilter() != null) {
            return new ActorHandlerInfo().allowStandalones(true).allowSource(false).actorExecution(ActorExecution.UNDEFINED).forwardsInput(false).restrictions(this.getActorFilter());
        }
        return this.m_Actors.getActorHandlerInfo();
    }

    protected abstract String doSetUpSubActors();

    protected String setUpSubActors() {
        String result = null;
        if (!this.getSkip()) {
            this.updateParent();
            result = this.doSetUpSubActors();
            if (result == null) {
                result = this.m_Actors.setUp();
            }
        }
        return result;
    }

    protected String doExecute() {
        return null;
    }

    public void cleanUp() {
        this.m_Actors.cleanUp();
        super.cleanUp();
    }
}

