/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.container.ProcessActorContainer;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.processor.ActorProcessor;
import adams.flow.processor.GraphicalOutputProducingProcessor;
import adams.flow.processor.ListingProcessor;
import adams.flow.processor.ModifyingProcessor;
import adams.flow.processor.MultiProcessor;
import adams.flow.transformer.AbstractInteractiveTransformerDialog;
import adams.gui.core.BasePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;

public class ProcessActor
extends AbstractInteractiveTransformerDialog {
    private static final long serialVersionUID = 1877006726746922569L;
    protected ActorProcessor m_Processor;
    protected boolean m_ShowGraphicalOutput;
    protected transient Component m_Component;

    public String globalInfo() {
        return "Applies the specified processor to the incoming actor and forwards the result.\nFor processors implementing " + Utils.classToString(ModifyingProcessor.class) + " the modified actor is forwarded (or, if not modified, the original one), all others just forward the incoming actor.\nIf the processor should implement " + Utils.classToString(ListingProcessor.class) + " then any generated list gets stored as string array in the outgoing container as well.\nProcessors implementing " + Utils.classToString(GraphicalOutputProducingProcessor.class) + " can optionally display the graphical output as well (off by default).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("processor", "processor", (Object)new MultiProcessor());
        this.m_OptionManager.add("show-graphical-output", "showGraphicalOutput", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_Component = null;
    }

    public void setProcessor(ActorProcessor value) {
        this.m_Processor = value;
        this.reset();
    }

    public ActorProcessor getProcessor() {
        return this.m_Processor;
    }

    public String processorTipText() {
        return "The actor processor to apply to the incoming actor.";
    }

    public void setShowGraphicalOutput(boolean value) {
        this.m_ShowGraphicalOutput = value;
        this.reset();
    }

    public boolean getShowGraphicalOutput() {
        return this.m_ShowGraphicalOutput;
    }

    public String showGraphicalOutputTipText() {
        return "If enabled, any Swing components generated by a " + Utils.classToString(GraphicalOutputProducingProcessor.class) + " processor will get displayed.";
    }

    public String getQuickInfo() {
        String result = this.m_Processor instanceof GraphicalOutputProducingProcessor && this.m_ShowGraphicalOutput ? super.getQuickInfo() + ", " : "";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"processor", (Object)this.m_Processor, (String)"processor: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"showGraphicalOutput", (boolean)this.m_ShowGraphicalOutput, (String)"show output", (String)", ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Actor.class};
    }

    public Class[] generates() {
        return new Class[]{ProcessActorContainer.class};
    }

    public void clearPanel() {
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        if (this.m_Component != null) {
            result.add(this.m_Component, (Object)"Center");
        }
        return result;
    }

    protected String createTitle() {
        String result = super.createTitle();
        if (this.m_Processor instanceof GraphicalOutputProducingProcessor) {
            result = result + " - " + ((GraphicalOutputProducingProcessor)this.m_Processor).getTitle();
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        Actor actor = (Actor)this.m_InputToken.getPayload(Actor.class);
        this.m_Component = null;
        ProcessActorContainer cont = null;
        try {
            this.m_Processor.process(actor);
            if (this.m_Processor instanceof ModifyingProcessor) {
                if (((ModifyingProcessor)this.m_Processor).isModified()) {
                    cont = new ProcessActorContainer(((ModifyingProcessor)this.m_Processor).getModifiedActor());
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Actor got modified, forwarding modified one");
                    }
                } else {
                    cont = new ProcessActorContainer(actor);
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Actor didn't get modified, forwarding original one");
                    }
                }
            } else {
                cont = new ProcessActorContainer(actor);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Forwarding original actor");
                }
            }
            if (this.m_Processor instanceof ListingProcessor) {
                cont.setValue("List", ((ListingProcessor)this.m_Processor).getList().toArray(new String[0]));
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Added list");
                }
            }
            if (this.m_Processor instanceof GraphicalOutputProducingProcessor && ((GraphicalOutputProducingProcessor)this.m_Processor).hasGraphicalOutput()) {
                this.m_Component = ((GraphicalOutputProducingProcessor)this.m_Processor).getGraphicalOutput();
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Generated graphical output");
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to process actor!", e);
        }
        if (result == null && this.m_Component != null && this.m_ShowGraphicalOutput) {
            result = super.doExecute();
        }
        if (result == null && cont != null) {
            this.m_OutputToken = new Token((Object)cont);
        }
        return result;
    }
}

