/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.FlowStructureModifier;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.ErrorHandler;
import adams.flow.core.OptionalCallableActor;

public abstract class AbstractCopyCallableActor
extends AbstractActor
implements FlowStructureModifier,
OptionalCallableActor {
    private static final long serialVersionUID = -7860206690560690212L;
    protected CallableActorReference m_CallableName;
    protected CallableActorHelper m_Helper;
    protected boolean m_Optional;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("callable", "callableName", (Object)new CallableActorReference("unknown"));
        this.m_OptionManager.add("optional", "optional", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    public void setCallableName(CallableActorReference value) {
        this.m_CallableName = value;
        this.reset();
    }

    public CallableActorReference getCallableName() {
        return this.m_CallableName;
    }

    public String callableNameTipText() {
        return "The name of the callable actor to use.";
    }

    public void setOptional(boolean value) {
        this.m_Optional = value;
        this.reset();
    }

    public boolean getOptional() {
        return this.m_Optional;
    }

    public String optionalTipText() {
        return "If enabled, then the callable actor is optional, ie no error is raised if not found, merely ignored.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"callableName", (Object)this.m_CallableName);
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"optional", (boolean)this.m_Optional, (String)"optional", (String)", ");
        return result;
    }

    protected Actor findCallableActor() {
        return this.m_Helper.findCallableActorRecursive((Actor)this, this.getCallableName());
    }

    public boolean isModifyingStructure() {
        return !this.getSkip();
    }

    protected abstract String checkCallableActor(Actor var1);

    protected abstract Actor getDefaultActor();

    protected String setUpCallableActor() {
        Object result = null;
        Actor actor = this.findCallableActor();
        if (actor == null) {
            if (!this.getOptional()) {
                result = "Couldn't find callable actor '" + this.getCallableName() + "'!";
            } else {
                actor = this.getDefaultActor();
            }
        }
        if (actor != null && (result = this.checkCallableActor(actor)) == null) {
            actor = actor.shallowCopy();
            actor.setParent(this.getParent());
            actor.setVariables(this.getVariables());
            result = actor.setUp();
            if (result == null) {
                if (actor.getName().equals(actor.getDefaultName())) {
                    actor.setName(this.getName());
                }
                actor.setVariables(this.getVariables());
                ((ActorHandler)this.getParent()).set(this.index(), actor);
                result = actor.setUp();
                if (this.getErrorHandler() != this) {
                    ActorUtils.updateErrorHandler((Actor)actor, (ErrorHandler)this.getErrorHandler(), (boolean)this.isLoggingEnabled());
                }
                if (result == null) {
                    actor.getOptionManager().updateVariableValues(true);
                }
                this.setParent(null);
                this.cleanUp();
            }
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.setUpCallableActor();
        }
        return result;
    }

    protected String doExecute() {
        return null;
    }
}

