/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.MessageCollection;
import adams.core.io.FlowFile;
import adams.core.io.PlaceholderFile;
import adams.flow.core.AbstractBaseExternalActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.ErrorHandler;

public abstract class AbstractIncludeExternalActor
extends AbstractBaseExternalActor {
    private static final long serialVersionUID = -7860206690560690212L;

    protected abstract String checkExternalActor(Actor var1);

    public String setUpExternalActor() {
        Object result = null;
        FlowFile file = this.m_ActorFile;
        if (file.toString().startsWith("@{")) {
            file = new PlaceholderFile(this.getVariables().expand(file.toString()));
        }
        if (!file.isFile()) {
            result = "'" + file.getAbsolutePath() + "' does not point to a file!";
        } else {
            MessageCollection errors = new MessageCollection();
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("Attempting to load actor file: " + (PlaceholderFile)file);
            }
            Actor externalActor = ActorUtils.read((String)file.getAbsolutePath(), (MessageCollection)errors);
            if (!errors.isEmpty()) {
                result = "Error loading external actor '" + file.getAbsolutePath() + "':\n" + errors;
            } else if (externalActor == null) {
                result = "Error loading external actor '" + file.getAbsolutePath() + "'!";
            } else {
                result = this.checkExternalActor(externalActor);
                if (result == null) {
                    if (externalActor.getName().equals(externalActor.getDefaultName())) {
                        externalActor.setName(this.getName());
                    }
                    externalActor.setVariables(this.getVariables());
                    ((ActorHandler)this.getParent()).set(this.index(), externalActor);
                    result = externalActor.setUp();
                    if (this.getErrorHandler() != this) {
                        ActorUtils.updateErrorHandler((Actor)externalActor, (ErrorHandler)this.getErrorHandler(), (boolean)this.isLoggingEnabled());
                    }
                    if (result == null) {
                        externalActor.getOptionManager().updateVariableValues(true);
                    }
                    this.setParent(null);
                    this.cleanUp();
                }
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("Actor file load/setUp result: " + (String)result);
            }
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.setUpExternalActor();
        }
        return result;
    }

    protected String doExecute() {
        return null;
    }
}

