/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.Utils;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.AbstractTextAndComponentDisplayPanel;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.flow.tree.Tree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;

public class FlowDisplay
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
TextSupplier {
    private static final long serialVersionUID = -4848073007226064084L;
    protected Tree m_Tree;

    public String globalInfo() {
        return "Displays an actor or flow.";
    }

    public Class[] accepts() {
        return new Class[]{Actor.class};
    }

    protected void display(Token token) {
        this.m_Tree.setActor((Actor)token.getPayload());
    }

    public boolean supportsClear() {
        return true;
    }

    public void clearPanel() {
        this.m_Tree.setActor(null);
    }

    protected BasePanel newPanel() {
        this.m_Tree = new Tree(null);
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        result.add((Component)new BaseScrollPane((Component)this.m_Tree), (Object)"Center");
        return result;
    }

    public String getCustomSupplyTextMenuItemCaption() {
        return "Save flow as...";
    }

    public ExtensionFileFilter getCustomTextFileFilter() {
        return new ExtensionFileFilter("Flow file", "flow");
    }

    public String supplyText() {
        return Utils.flatten((List)this.m_Tree.getCommandLines(), (String)"\n");
    }

    public DisplayPanel createDisplayPanel(Token token) {
        return new AbstractTextAndComponentDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = -2507397847572050956L;
            protected Tree m_Tree;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_Tree = new Tree(null);
                this.add((Component)new BaseScrollPane((Component)this.m_Tree), "Center");
            }

            public JComponent supplyComponent() {
                return this.m_Tree;
            }

            public ExtensionFileFilter getCustomTextFileFilter() {
                return new ExtensionFileFilter("Flow file", "flow");
            }

            public String supplyText() {
                return Utils.flatten((List)this.m_Tree.getCommandLines(), (String)"\n");
            }

            public void display(Token token) {
                this.m_Tree.setActor((Actor)token.getPayload());
            }

            public void clearPanel() {
                this.m_Tree.setActor(null);
            }

            public void cleanUp() {
                this.m_Tree.cleanUp();
            }
        };
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    public void cleanUp() {
        if (this.m_Tree != null) {
            this.m_Tree.cleanUp();
            this.m_Tree = null;
        }
        super.cleanUp();
    }
}

