/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.io.output.DefaultFlowWriter;
import adams.data.io.output.FlowWriter;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.sink.AbstractFileWriter;
import java.io.File;

public class FlowFileWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = 2859778244702202261L;
    protected boolean m_UseCustomWriter;
    protected FlowWriter m_CustomWriter;

    public String globalInfo() {
        return "Writes the incoming actor(s) to a file.\nA custom flow writer can be specified.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-custom-writer", "useCustomWriter", (Object)false);
        this.m_OptionManager.add("custom-writer", "customWriter", (Object)new DefaultFlowWriter());
    }

    public String outputFileTipText() {
        return "The file to write the actor to.";
    }

    public void setUseCustomWriter(boolean value) {
        this.m_UseCustomWriter = value;
        this.reset();
    }

    public boolean getUseCustomWriter() {
        return this.m_UseCustomWriter;
    }

    public String useCustomWriterTipText() {
        return "If enabled, the specified writer will be used instead of auto-detection.";
    }

    public void setCustomWriter(FlowWriter value) {
        this.m_CustomWriter = value;
        this.reset();
    }

    public FlowWriter getCustomWriter() {
        return this.m_CustomWriter;
    }

    public String customWriterTipText() {
        return "The writer to use if a custom writer is to be used.";
    }

    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        if (this.m_UseCustomWriter) {
            result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"customWriter", (Object)this.m_CustomWriter, (String)", writer: ");
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Actor.class};
    }

    protected String doExecute() {
        String result = null;
        Actor actor = null;
        if (this.m_InputToken.getPayload() instanceof Actor) {
            actor = (Actor)this.m_InputToken.getPayload();
        } else {
            result = "Unhandled input: " + Utils.classToString((Object)this.m_InputToken.getPayload());
        }
        if (result == null) {
            if (this.m_UseCustomWriter) {
                if (!this.m_CustomWriter.write(actor, (File)this.m_OutputFile)) {
                    result = "Failed to write actor to: " + this.m_OutputFile;
                }
            } else if (!ActorUtils.write((String)this.m_OutputFile.getAbsolutePath(), (Actor)actor)) {
                result = "Failed to write actor to: " + this.m_OutputFile;
            }
        }
        return result;
    }
}

