/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;

public class CurrentFlow
extends AbstractSimpleSource {
    private static final long serialVersionUID = 3823225606368312035L;
    protected boolean m_ExpandVariables;

    public String globalInfo() {
        return "Outputs the current flow, i.e., itself.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expand-variables", "expandVariables", (Object)false);
    }

    public void setExpandVariables(boolean value) {
        this.m_ExpandVariables = value;
        this.reset();
    }

    public boolean getExpandVariables() {
        return this.m_ExpandVariables;
    }

    public String expandVariablesTipText() {
        return "If enabled, variables get expanded to their current values.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"expandVariables", (Object)(this.m_ExpandVariables ? "expand vars" : ""));
    }

    public Class[] generates() {
        return new Class[]{Actor.class};
    }

    protected String doExecute() {
        String result = null;
        Actor actor = this.getRoot();
        if (actor == null) {
            result = "Failed to obtain root actor!";
        } else if (this.m_ExpandVariables) {
            actor = actor.shallowCopy(true);
        }
        if (actor != null) {
            this.m_OutputToken = new Token((Object)actor);
        }
        return result;
    }
}

