/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorPath;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;

public class SpecifiedActor
extends AbstractSimpleSource {
    private static final long serialVersionUID = 3823225606368312035L;
    protected ActorPath m_Path;
    protected boolean m_ExpandVariables;
    protected boolean m_NoSubActors;

    public String globalInfo() {
        return "Outputs the actor identified by the actor path.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("path", "path", (Object)new ActorPath());
        this.m_OptionManager.add("expand-variables", "expandVariables", (Object)false);
        this.m_OptionManager.add("no-sub-actors", "noSubActors", (Object)false);
    }

    public void setPath(ActorPath value) {
        this.m_Path = value;
        this.reset();
    }

    public ActorPath getPath() {
        return this.m_Path;
    }

    public String pathTipText() {
        return "The path of the actor to output.";
    }

    public void setExpandVariables(boolean value) {
        this.m_ExpandVariables = value;
        this.reset();
    }

    public boolean getExpandVariables() {
        return this.m_ExpandVariables;
    }

    public String expandVariablesTipText() {
        return "If enabled, variables get expanded to their current values.";
    }

    public void setNoSubActors(boolean value) {
        this.m_NoSubActors = value;
        this.reset();
    }

    public boolean getNoSubActors() {
        return this.m_NoSubActors;
    }

    public String noSubActorsTipText() {
        return "If enabled, actor handlers will have their sub-actors removed.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"path", (Object)(this.m_Path.isEmpty() ? "-none-" : this.m_Path.toString()), (String)"path: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"expandVariables", (Object)(this.m_ExpandVariables ? "expand vars" : "with vars"), (String)", ");
        return result;
    }

    public Class[] generates() {
        return new Class[]{Actor.class};
    }

    protected String doExecute() {
        String result = null;
        Actor actor = ActorUtils.locate((ActorPath)this.m_Path, (Actor)this.getRoot(), (boolean)true, (boolean)false);
        if (actor == null) {
            result = "Failed to locate actor: " + this.m_Path;
        } else {
            if (this.m_ExpandVariables) {
                actor = actor.shallowCopy(true);
            }
            if (this.m_NoSubActors) {
                actor = ActorUtils.strip((Actor)actor);
            }
        }
        if (actor != null) {
            this.m_OutputToken = new Token((Object)actor);
        }
        return result;
    }
}

