/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.flow.core.AbstractTemplate;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.template.AbstractActorTemplate;
import adams.flow.template.DummySource;

public class TemplateSource
extends AbstractTemplate
implements OutputProducer {
    private static final long serialVersionUID = 2906214610648390363L;

    public String globalInfo() {
        return "Broadcasts the generated output tokens from the (template) source.";
    }

    @Override
    protected AbstractActorTemplate getDefaultTemplate() {
        return new DummySource();
    }

    @Override
    protected String setUpTemplate() {
        Object result = super.setUpTemplate();
        if (result == null && !ActorUtils.isSource((Actor)this.m_Actor)) {
            result = "Template '" + this.m_Template + "' does not generate a source actor: " + this.m_Actor.getClass().getName();
        }
        return result;
    }

    public Class[] generates() {
        if (this.m_Actor != null) {
            return ((OutputProducer)this.m_Actor).generates();
        }
        return new Class[]{Unknown.class};
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Actor == null) {
            result = this.setUpTemplate();
        }
        if (result == null) {
            result = this.m_Actor.execute();
        }
        return result;
    }

    public Token output() {
        return ((OutputProducer)this.m_Actor).output();
    }

    public boolean hasPendingOutput() {
        return this.m_Actor != null && ((OutputProducer)this.m_Actor).hasPendingOutput();
    }
}

