/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.Variables;
import adams.core.option.OptionHandler;
import adams.flow.container.EncapsulatedActorsContainer;
import adams.flow.control.Storage;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.FlowExecutionListeningSupporter;
import adams.flow.execution.NullListener;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;

public class ExecuteActor
extends AbstractTransformer
implements FlowExecutionListeningSupporter {
    private static final long serialVersionUID = 1877006726746922569L;
    protected boolean m_CallSetUp;
    protected boolean m_CallWrapUp;
    protected boolean m_CallCleanUp;
    protected transient Actor m_Actor;
    protected boolean m_FlowExecutionListeningEnabled;
    protected FlowExecutionListener m_FlowExecutionListener;

    public String globalInfo() {
        return "Executes the actor passing through and forwards it once finished.\nIf the actor is an instance of " + Utils.classToString(FlowExecutionListeningSupporter.class) + " and flow execution listening enabled, then the specified flow execution listener gets attached.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("call-setup", "callSetUp", (Object)false);
        this.m_OptionManager.add("call-wrapup", "callWrapUp", (Object)false);
        this.m_OptionManager.add("call-cleanup", "callCleanUp", (Object)false);
        this.m_OptionManager.add("flow-execution-listening-enabled", "flowExecutionListeningEnabled", (Object)false);
        this.m_OptionManager.add("flow-execution-listener", "flowExecutionListener", (Object)new NullListener());
    }

    public void setCallSetUp(boolean value) {
        this.m_CallSetUp = value;
        this.reset();
    }

    public boolean getCallSetUp() {
        return this.m_CallSetUp;
    }

    public String callSetUpTipText() {
        return "If enabled, the actor's 'setUp()' method gets called.";
    }

    public void setCallWrapUp(boolean value) {
        this.m_CallWrapUp = value;
        this.reset();
    }

    public boolean getCallWrapUp() {
        return this.m_CallWrapUp;
    }

    public String callWrapUpTipText() {
        return "If enabled, the actor's 'wrapUp()' method gets called.";
    }

    public void setCallCleanUp(boolean value) {
        this.m_CallCleanUp = value;
        this.reset();
    }

    public boolean getCallCleanUp() {
        return this.m_CallCleanUp;
    }

    public String callCleanUpTipText() {
        return "If enabled, the actor's 'cleanUp()' method gets called.";
    }

    public void setFlowExecutionListeningEnabled(boolean value) {
        this.m_FlowExecutionListeningEnabled = value;
        this.reset();
    }

    public boolean isFlowExecutionListeningEnabled() {
        return this.m_FlowExecutionListeningEnabled;
    }

    public String flowExecutionListeningEnabledTipText() {
        return "Enables/disables the flow execution listener.";
    }

    public void setFlowExecutionListener(FlowExecutionListener l) {
        this.m_FlowExecutionListener = l;
        this.reset();
    }

    public FlowExecutionListener getFlowExecutionListener() {
        return this.m_FlowExecutionListener;
    }

    public String flowExecutionListenerTipText() {
        return "The listener for the flow execution; must be enabled explicitly.";
    }

    public boolean canStartListeningAtRuntime() {
        return false;
    }

    public boolean startListeningAtRuntime(FlowExecutionListener l) {
        return false;
    }

    public String getQuickInfo() {
        Object result = "";
        if (this.m_FlowExecutionListeningEnabled || QuickInfoHelper.hasVariable((OptionHandler)this, (String)"executionListener")) {
            result = QuickInfoHelper.toString((OptionHandler)this, (String)"executionListener", (Object)this.m_FlowExecutionListener, (String)"listener: ");
        }
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"callSetUp", (boolean)this.m_CallSetUp, (String)"call setUp"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"callWrapUp", (boolean)this.m_CallWrapUp, (String)"call wrapUp"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"callCleanUp", (boolean)this.m_CallCleanUp, (String)"call cleanUp"));
        result = (String)result + QuickInfoHelper.flatten(options);
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Actor.class, EncapsulatedActorsContainer.class};
    }

    public Class[] generates() {
        return new Class[]{Actor.class};
    }

    protected String doExecute() {
        String result = null;
        EncapsulatedActorsContainer cont = null;
        Storage storage = null;
        Variables variables = null;
        if (this.m_InputToken.hasPayload(Actor.class)) {
            this.m_Actor = (Actor)this.m_InputToken.getPayload(Actor.class);
        } else if (this.m_InputToken.hasPayload(EncapsulatedActorsContainer.class)) {
            cont = (EncapsulatedActorsContainer)((Object)this.m_InputToken.getPayload(EncapsulatedActorsContainer.class));
            this.m_Actor = (Actor)cont.getValue("Actor", Actor.class);
            storage = (Storage)cont.getValue("Storage", Storage.class);
            variables = (Variables)cont.getValue("Variables", Variables.class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (this.m_Actor == null) {
            result = "No actor available!";
        }
        if (result == null) {
            if (this.m_FlowExecutionListeningEnabled && this.m_Actor instanceof FlowExecutionListeningSupporter) {
                ((FlowExecutionListeningSupporter)this.m_Actor).setFlowExecutionListener((FlowExecutionListener)ObjectCopyHelper.copyObject((Object)this.m_FlowExecutionListener));
                ((FlowExecutionListeningSupporter)this.m_Actor).setFlowExecutionListeningEnabled(true);
            }
            try {
                if (this.m_CallSetUp) {
                    result = this.m_Actor.setUp();
                }
                if (result == null) {
                    if (variables != null) {
                        this.m_Actor.getVariables().assign(variables);
                    }
                    if (storage != null) {
                        this.m_Actor.getStorageHandler().getStorage().assign(storage);
                    }
                    result = this.m_Actor.execute();
                }
                if (this.m_CallWrapUp) {
                    this.m_Actor.wrapUp();
                }
                if (this.m_CallCleanUp) {
                    this.m_Actor.cleanUp();
                }
                if (result == null) {
                    if (cont == null) {
                        this.m_OutputToken = new Token((Object)this.m_Actor);
                    } else {
                        if (cont.hasValue("Output name")) {
                            cont.setValue("Output", this.m_Actor.getStorageHandler().getStorage().get((StorageName)cont.getValue("Output name", StorageName.class)));
                        }
                        this.m_OutputToken = new Token((Object)cont);
                    }
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to execute actor!", e);
            }
        }
        this.m_Actor = null;
        return result;
    }

    public void stopExecution() {
        if (this.m_Actor != null) {
            this.m_Actor.stopExecution();
        }
        super.stopExecution();
    }

    public void wrapUp() {
        this.m_Actor = null;
        super.wrapUp();
    }
}

