/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.io.input.DefaultFlowReader;
import adams.data.io.input.FlowReader;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;

public class FlowFileReader
extends AbstractTransformer {
    private static final long serialVersionUID = -1258602500279600946L;
    protected boolean m_UseCustomReader;
    protected FlowReader m_CustomReader;

    public String globalInfo() {
        return "Reads the flow file and outputs the actor(s).\nA custom reader can be specified in case of reading from files, but must be specified when reading from " + Utils.classToString(Reader.class) + " or " + Utils.classToString(InputStream.class) + " objects.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-custom-reader", "useCustomReader", (Object)false);
        this.m_OptionManager.add("custom-reader", "customReader", (Object)new DefaultFlowReader());
    }

    public void setUseCustomReader(boolean value) {
        this.m_UseCustomReader = value;
        this.reset();
    }

    public boolean getUseCustomReader() {
        return this.m_UseCustomReader;
    }

    public String useCustomReaderTipText() {
        return "If enabled, the specified reader will be used instead of auto-detection.";
    }

    public void setCustomReader(FlowReader value) {
        this.m_CustomReader = value;
        this.reset();
    }

    public FlowReader getCustomReader() {
        return this.m_CustomReader;
    }

    public String customReaderTipText() {
        return "The reader to use if a custom reader is to be used.";
    }

    public String getQuickInfo() {
        if (this.m_UseCustomReader) {
            return QuickInfoHelper.toString((OptionHandler)this, (String)"customReader", (Object)this.m_CustomReader, (String)"custom reader: ");
        }
        return null;
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{Actor.class};
    }

    protected String doExecute() {
        String result = null;
        PlaceholderFile file = null;
        Reader reader = null;
        InputStream stream = null;
        if (this.m_InputToken.hasPayload(String.class)) {
            file = new PlaceholderFile((String)this.m_InputToken.getPayload(String.class));
        } else if (this.m_InputToken.hasPayload(File.class)) {
            file = new PlaceholderFile((File)this.m_InputToken.getPayload(File.class));
        } else if (this.m_InputToken.hasPayload(Reader.class)) {
            reader = (Reader)this.m_InputToken.getPayload(Reader.class);
        } else if (this.m_InputToken.hasPayload(InputStream.class)) {
            stream = (InputStream)this.m_InputToken.getPayload(InputStream.class);
        } else {
            result = "Unhandled input: " + Utils.classToString((Object)this.m_InputToken.getPayload());
        }
        Actor actor = null;
        if (result == null) {
            MessageCollection errors = new MessageCollection();
            if (this.m_UseCustomReader) {
                if (file != null) {
                    actor = this.m_CustomReader.readActor((File)file);
                } else if (reader != null) {
                    actor = this.m_CustomReader.readActor(reader);
                } else if (stream != null) {
                    actor = this.m_CustomReader.readActor(stream);
                }
                errors.addAll(this.m_CustomReader.getErrors());
            } else if (file != null) {
                actor = ActorUtils.read((String)file.getAbsolutePath(), (MessageCollection)errors);
            } else {
                result = "Custom reader specification required for " + Utils.classToString(Reader.class) + " or " + Utils.classToString(InputStream.class) + " objects.";
            }
            if (!errors.isEmpty()) {
                result = "Failed to load actor from: " + file + "\n" + errors;
                actor = null;
            }
        }
        if (actor != null) {
            this.m_OutputToken = new Token(actor);
        }
        return result;
    }
}

