/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tab;

import adams.core.base.BaseKeyValuePair;
import adams.core.tags.TagProcessorHelper;
import adams.flow.core.Actor;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTable;
import adams.gui.core.KeyValuePairTableModel;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.flow.tab.AbstractEditorTab;
import adams.gui.flow.tab.SelectionAwareEditorTab;
import adams.gui.flow.tree.TreeHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;

public class EffectiveTagsTab
extends AbstractEditorTab
implements SelectionAwareEditorTab {
    private static final long serialVersionUID = 3860012648562358118L;
    public static final String[] COLUMN_NAMES = new String[]{"Tag", "Value"};
    protected SortableAndSearchableTable m_Table;
    protected KeyValuePairTableModel m_Model;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Model = new KeyValuePairTableModel((Object[][])new Object[0][], COLUMN_NAMES);
        this.m_Table = new SortableAndSearchableTable((TableModel)this.m_Model);
        this.m_Table.setShowSimplePopupMenus(true);
        this.m_Table.setColumnWidthApproach(BaseTable.ColumnWidthApproach.ADAPTIVE);
        this.add((Component)new BaseScrollPane((Component)this.m_Table), "Center");
    }

    public String getTitle() {
        return "Effective tags";
    }

    public void actorSelectionChanged(TreePath[] paths, Actor[] actors) {
        if (actors.length != 1) {
            this.m_Model = new KeyValuePairTableModel((Object[][])new Object[0][], COLUMN_NAMES);
            Runnable run = () -> this.m_Table.setModel((TableModel)this.m_Model);
            SwingUtilities.invokeLater(run);
            return;
        }
        List<BaseKeyValuePair> tags = TagProcessorHelper.getAllTags(TreeHelper.pathToNode((TreePath)paths[0]), true);
        Object[][] data = new String[tags.size()][2];
        for (int i = 0; i < tags.size(); ++i) {
            data[i] = new String[]{tags.get(i).getPairKey(), tags.get(i).getPairValue()};
        }
        this.m_Model = new KeyValuePairTableModel(data, COLUMN_NAMES);
        Runnable run = () -> this.m_Table.setModel((TableModel)this.m_Model);
        SwingUtilities.invokeLater(run);
    }
}

