/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Dataset.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.ml;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.Vector;

/**
 * 
 *
 * @author  dale (dale at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class Dataset implements Serializable,Cloneable{

  public class Mapping {
    public Mapping(BaseData.Type typ){
      m_type=typ;
    }
    public Mapping(){
    }
    protected BaseData.Type m_type;
    protected BaseData.Type m_basetype; // for arrays
    protected int m_size=-1; //for arrays
  }
  protected Hashtable<String,Mapping> m_Mapping;
  /**
   *
   */
  private static final long serialVersionUID = 4458447431240251541L;

  /** optional name of this dataset. */
  protected String m_name="";

  protected Vector<DataRow> m_rows;

  public Dataset(String name){
    m_name=name;
    m_Mapping = new Hashtable<String,Mapping>();
    m_rows=new Vector<DataRow>();
  }
  public Dataset(){
    m_Mapping = new Hashtable<String,Mapping>();
    m_rows=new Vector<DataRow>();
  }
  public void setType(String key, BaseData.Type type){
    Mapping m=new Mapping();
    m.m_type=type;
    m_Mapping.put(key, m);
  }

  public void setType(String key, BaseData.Type basetype, int size){
    Mapping m=new Mapping();
    m.m_type=BaseData.Type.ARRAY;
    m.m_basetype=basetype;
    m.m_size=size;
    m_Mapping.put(key, m);
  }

  public void setMappingFromBaseData(String key, BaseData bd){

    if (bd != null){

      if (bd.isNumeric()){
	setType(key,BaseData.Type.NUMERIC);
      } else if (bd.isArray()){
	if (Array.getLength(bd.getData()) > 0){
	  Object ao=Array.get(bd.getData(), 0);
	  if (BaseData.isNumeric(ao)){
	    setType(key,BaseData.Type.NUMERIC,Array.getLength(bd.getData()));
	  } else {
	    setType(key,BaseData.Type.STRING,Array.getLength(bd.getData()));
	  }
	}
      } else {
	setType(key,BaseData.Type.STRING);
      }
    }
  }

  public BaseData.Type getArrayType(Object bd){

    if (bd != null){
      if (BaseData.isNumeric(bd)){
	return(BaseData.Type.NUMERIC);
      } else if (BaseData.isArray(bd)){
	System.err.println("can't handle Multidim array");
	return(null);
      } else {
	return(BaseData.Type.STRING);
      }
    } else {
      return(null);
    }
  }

  public void setMappingFromDataRow(DataRow dr){
    for (String key:dr.getKeys()){
      BaseData bd=dr.get(key);
      if (bd != null){
	if (bd.isNumeric()){
	  setType(key,BaseData.Type.NUMERIC);
	} else if (bd.isArray()){
	  if (Array.getLength(bd.getData()) > 0){
	    Object ao=Array.get(bd.getData(), 0);
	    if (BaseData.isNumeric(ao)){
	      setType(key,BaseData.Type.NUMERIC,Array.getLength(bd.getData()));
	    } else {
	      setType(key,BaseData.Type.STRING,Array.getLength(bd.getData()));
	    }
	  }
	} else {
	  setType(key,BaseData.Type.STRING);
	}
      }
    }
  }

  public Dataset copy(){
    Dataset ret=new Dataset(m_name);
    for (DataRow dr:m_rows){
      ret.add(dr.copy());
    }
    //ret.m_rows=(Vector<DataRow>)m_rows.clone();
    return(ret);
  }

  public void empty(){
    m_rows=new Vector<DataRow>();
  }
  public void useWithoutCheck(Dataset d){
    m_rows=new Vector<DataRow>();
    for (DataRow dr:d.m_rows){
      addWithoutCheck(dr.copy());
    }
  }
  public void use(Dataset d){
    m_rows=new Vector<DataRow>();
    for (DataRow dr:d.m_rows){
      add((DataRow)dr.copy());
    }
  }
  public String getName(){
    return(m_name);
  }
  public void setName(String name){
    m_name=name;
  }

  public boolean add(DataRow dr){
    for (String s:dr.getKeys()){
      Mapping m=m_Mapping.get(s);
      if (m==null){
	setMappingFromBaseData(s, dr.get(s));
      } else {
	boolean eq=BaseData.typeEquals(dr.getObject(s), m.m_type);
	if (!eq){
	  System.err.println("Fails insert:"+s+","+m.m_type.toString()+","+BaseData.getType(dr.getObject(s)));
	  return(false);
	}
      }
    }
    m_rows.add(dr);
    return(true);
  }

  public void addWithoutCheck(DataRow dr){
    m_rows.add(dr);
  }
  public int count(){
    return(m_rows.size());
  }
  public DataRow get(int i){
    return(m_rows.get(i));
  }
  public void autoID(String key){
    int i=1;
    for (DataRow dr:m_rows){
      dr.set(key, new BaseData(i++));
    }
  }

  public String toString(){
    StringBuffer sb=new StringBuffer();
    for (int i=0;i<count();i++){
      DataRow dr=get(i);
      for (String s:dr.getKeys()){
	Object o=dr.getObject(s);
	if (o != null && o.getClass().isArray()){
	  sb.append("("+s+":");
	  for (int j=0;j<Array.getLength(o);j++){
	    Object p=Array.get(o, j);
	    sb.append(p.toString());
	    if (j < Array.getLength(o)-1){
	      sb.append(",");
	    }
	  }
	  sb.append(")");
	} else if (o != null ){
	  sb.append("("+s+":"+o.toString()+")");
	}
      }
      sb.append("\n");
    }
    return(sb.toString());
  }

}
