/*
 * Decompiled with CFR 0.152.
 */
package adams.ml;

import adams.ml.BaseData;
import adams.ml.DataRow;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.Vector;

public class Dataset
implements Serializable,
Cloneable {
    protected Hashtable<String, Mapping> m_Mapping;
    private static final long serialVersionUID = 4458447431240251541L;
    protected String m_name = "";
    protected Vector<DataRow> m_rows;

    public Dataset(String name) {
        this.m_name = name;
        this.m_Mapping = new Hashtable();
        this.m_rows = new Vector();
    }

    public Dataset() {
        this.m_Mapping = new Hashtable();
        this.m_rows = new Vector();
    }

    public void setType(String key, BaseData.Type type) {
        Mapping m = new Mapping();
        m.m_type = type;
        this.m_Mapping.put(key, m);
    }

    public void setType(String key, BaseData.Type basetype, int size) {
        Mapping m = new Mapping();
        m.m_type = BaseData.Type.ARRAY;
        m.m_basetype = basetype;
        m.m_size = size;
        this.m_Mapping.put(key, m);
    }

    public void setMappingFromBaseData(String key, BaseData bd) {
        if (bd != null) {
            if (bd.isNumeric()) {
                this.setType(key, BaseData.Type.NUMERIC);
            } else if (bd.isArray()) {
                if (Array.getLength(bd.getData()) > 0) {
                    Object ao = Array.get(bd.getData(), 0);
                    if (BaseData.isNumeric(ao)) {
                        this.setType(key, BaseData.Type.NUMERIC, Array.getLength(bd.getData()));
                    } else {
                        this.setType(key, BaseData.Type.STRING, Array.getLength(bd.getData()));
                    }
                }
            } else {
                this.setType(key, BaseData.Type.STRING);
            }
        }
    }

    public BaseData.Type getArrayType(Object bd) {
        if (bd != null) {
            if (BaseData.isNumeric(bd)) {
                return BaseData.Type.NUMERIC;
            }
            if (BaseData.isArray(bd)) {
                System.err.println("can't handle Multidim array");
                return null;
            }
            return BaseData.Type.STRING;
        }
        return null;
    }

    public void setMappingFromDataRow(DataRow dr) {
        for (String key : dr.getKeys()) {
            BaseData bd = dr.get(key);
            if (bd == null) continue;
            if (bd.isNumeric()) {
                this.setType(key, BaseData.Type.NUMERIC);
                continue;
            }
            if (bd.isArray()) {
                if (Array.getLength(bd.getData()) <= 0) continue;
                Object ao = Array.get(bd.getData(), 0);
                if (BaseData.isNumeric(ao)) {
                    this.setType(key, BaseData.Type.NUMERIC, Array.getLength(bd.getData()));
                    continue;
                }
                this.setType(key, BaseData.Type.STRING, Array.getLength(bd.getData()));
                continue;
            }
            this.setType(key, BaseData.Type.STRING);
        }
    }

    public Dataset copy() {
        Dataset ret = new Dataset(this.m_name);
        for (DataRow dr : this.m_rows) {
            ret.add(dr.copy());
        }
        return ret;
    }

    public void empty() {
        this.m_rows = new Vector();
    }

    public void useWithoutCheck(Dataset d) {
        this.m_rows = new Vector();
        for (DataRow dr : d.m_rows) {
            this.addWithoutCheck(dr.copy());
        }
    }

    public void use(Dataset d) {
        this.m_rows = new Vector();
        for (DataRow dr : d.m_rows) {
            this.add(dr.copy());
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public boolean add(DataRow dr) {
        for (String s : dr.getKeys()) {
            Mapping m = this.m_Mapping.get(s);
            if (m == null) {
                this.setMappingFromBaseData(s, dr.get(s));
                continue;
            }
            boolean eq = BaseData.typeEquals(dr.getObject(s), m.m_type);
            if (eq) continue;
            System.err.println("Fails insert:" + s + "," + m.m_type.toString() + "," + (Object)((Object)BaseData.getType(dr.getObject(s))));
            return false;
        }
        this.m_rows.add(dr);
        return true;
    }

    public void addWithoutCheck(DataRow dr) {
        this.m_rows.add(dr);
    }

    public int count() {
        return this.m_rows.size();
    }

    public DataRow get(int i) {
        return this.m_rows.get(i);
    }

    public void autoID(String key) {
        int i = 1;
        for (DataRow dr : this.m_rows) {
            dr.set(key, new BaseData(i++));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.count(); ++i) {
            DataRow dr = this.get(i);
            for (String s : dr.getKeys()) {
                Object o = dr.getObject(s);
                if (o != null && o.getClass().isArray()) {
                    sb.append("(" + s + ":");
                    for (int j = 0; j < Array.getLength(o); ++j) {
                        Object p = Array.get(o, j);
                        sb.append(p.toString());
                        if (j >= Array.getLength(o) - 1) continue;
                        sb.append(",");
                    }
                    sb.append(")");
                    continue;
                }
                if (o == null) continue;
                sb.append("(" + s + ":" + o.toString() + ")");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public class Mapping {
        protected BaseData.Type m_type;
        protected BaseData.Type m_basetype;
        protected int m_size = -1;

        public Mapping(BaseData.Type typ) {
            this.m_type = typ;
        }

        public Mapping() {
        }
    }
}

