/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sequenceplotter;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.CrossHitDetector;
import adams.gui.visualization.sequence.DiameterBasedPaintlet;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;

public class OutlierPaintlet
extends AbstractXYSequencePaintlet
implements AntiAliasingSupporter,
DiameterBasedPaintlet {
    private static final long serialVersionUID = 6585282004697591762L;
    protected int m_Diameter;
    protected boolean m_AntiAliasingEnabled;
    protected Color m_ColorNormal;
    protected Color m_ColorOutlier;

    public String globalInfo() {
        return "Paintlet for painting crosses at the specified X-Y position, uses separate color for outliers if the meta-data key Outlier is set.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("diameter", "diameter", (Object)7, (Number)1, null);
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
        this.m_OptionManager.add("color-normal", "colorNormal", (Object)Color.BLUE);
        this.m_OptionManager.add("color-outlier", "colorOutlier", (Object)Color.RED);
    }

    public void setDiameter(int value) {
        this.m_Diameter = value;
        this.memberChanged();
    }

    public int getDiameter() {
        return this.m_Diameter;
    }

    public String diameterTipText() {
        return "The diameter of the cross in pixels.";
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing the crosses.";
    }

    public void setColorNormal(Color value) {
        this.m_ColorNormal = value;
        this.memberChanged();
    }

    public Color getColorNormal() {
        return this.m_ColorNormal;
    }

    public String colorNormalTipText() {
        return "The color for normal data points.";
    }

    public void setColorOutlier(Color value) {
        this.m_ColorOutlier = value;
        this.memberChanged();
    }

    public Color getColorOutlier() {
        return this.m_ColorOutlier;
    }

    public String colorOutlierTipText() {
        return "The color for outliers.";
    }

    public AbstractXYSequencePointHitDetector newHitDetector() {
        return new CrossHitDetector((XYSequencePaintlet)this);
    }

    public void drawData(Graphics g, PaintEvent.PaintMoment moment, XYSequence data) {
        List points = data.toList();
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
        int radius = this.m_Diameter / 2;
        Color lastColor = this.m_ColorNormal;
        g.setColor(lastColor);
        for (int i = 0; i < data.size(); ++i) {
            SequencePlotPoint curr = (SequencePlotPoint)points.get(i);
            int currX = axisX.valueToPos(XYSequencePoint.toDouble((Double)curr.getX()).doubleValue());
            int currY = axisY.valueToPos(XYSequencePoint.toDouble((Double)curr.getY()).doubleValue());
            Color currColor = this.m_ColorNormal;
            if (curr.hasMetaData() && curr.getMetaData().containsKey("Outlier") && ((Boolean)curr.getMetaData().get("Outlier")).booleanValue()) {
                currColor = this.m_ColorOutlier;
            }
            if (currColor != lastColor) {
                g.setColor(currColor);
                lastColor = currColor;
            }
            g.drawLine(currX - radius, currY - radius, currX + radius, currY + radius);
            g.drawLine(currX + radius, currY - radius, currX - radius, currY + radius);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        XYSequenceContainerManager xYSequenceContainerManager = this.getActualContainerManager();
        synchronized (xYSequenceContainerManager) {
            for (int i = 0; i < this.getActualContainerManager().count(); ++i) {
                XYSequence data;
                if (!this.getActualContainerManager().isVisible(i) || (data = ((XYSequenceContainer)this.getActualContainerManager().get(i)).getData()).size() == 0) continue;
                XYSequence xYSequence = data;
                synchronized (xYSequence) {
                    this.drawData(g, moment, data);
                    continue;
                }
            }
        }
    }
}

