/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sequenceplotter;

import adams.data.sequence.XYSequencePoint;
import adams.flow.sink.sequenceplotter.AbstractMouseClickAction;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.CrossHitDetector;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Vector;

public class ToggleOutlier
extends AbstractMouseClickAction {
    private static final long serialVersionUID = -214148459426250712L;
    protected AbstractXYSequencePointHitDetector m_HitDetector;

    public String globalInfo() {
        return "Toggles the outlier state of the data point(s).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("hit-detector", "hitDetector", (Object)new CrossHitDetector());
    }

    public void setHitDetector(AbstractXYSequencePointHitDetector value) {
        this.m_HitDetector = value;
        this.reset();
    }

    public AbstractXYSequencePointHitDetector getHitDetector() {
        return this.m_HitDetector;
    }

    public String hitDetectorTipText() {
        return "The hit detector to use.";
    }

    protected void processLeftClick(SequencePlotterPanel panel, MouseEvent e) {
        Object located;
        if (this.m_HitDetector.getOwner() != panel.getPaintlet()) {
            this.m_HitDetector.setOwner(panel.getPaintlet());
        }
        if ((located = this.m_HitDetector.locate(e)) instanceof Vector) {
            Vector hits = (Vector)located;
            for (XYSequencePoint hit : hits) {
                if (!(hit instanceof SequencePlotPoint)) continue;
                SequencePlotPoint point = (SequencePlotPoint)hit;
                if (point.hasMetaData()) {
                    if (point.getMetaData().containsKey("Outlier")) {
                        point.getMetaData().put("Outlier", (Boolean)point.getMetaData().get("Outlier") == false);
                        continue;
                    }
                    point.getMetaData().put("Outlier", true);
                    continue;
                }
                point.setMetaData(new HashMap());
                point.getMetaData().put("Outlier", true);
            }
            panel.update();
        }
    }

    protected void processRightClick(SequencePlotterPanel panel, MouseEvent e) {
    }
}

