/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.DecimalFormatString;
import adams.data.container.DataPoint;
import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePointComparator;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.container.OutlierContainer;
import adams.flow.control.removeoutliers.AbstractOutlierDetector;
import adams.flow.control.removeoutliers.Null;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.sink.sequenceplotter.MouseClickAction;
import adams.flow.sink.sequenceplotter.OutlierPaintlet;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.flow.sink.sequenceplotter.SequencePlotSequence;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.flow.sink.sequenceplotter.ToggleOutlier;
import adams.flow.transformer.AbstractInteractiveTransformerDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.core.AxisPanelOptions;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.LinearRegressionOverlayPaintlet;
import adams.gui.visualization.sequence.MultiPaintlet;
import adams.gui.visualization.sequence.StraightLineOverlayPaintlet;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class RemoveOutliers
extends AbstractInteractiveTransformerDialog {
    private static final long serialVersionUID = 5761075187069480059L;
    public static final String KEY_INDEX = "Index";
    public static final String KEY_INITIAL = "Initial";
    public static final String KEY_OUTLIER = "Outlier";
    protected AbstractOutlierDetector m_Detector;
    protected SpreadSheetColumnIndex m_ColumnActual;
    protected SpreadSheetColumnIndex m_ColumnPredicted;
    protected SequencePlotterPanel m_PlotterPanel;
    protected boolean m_Accepted;

    public String globalInfo() {
        return "Allows the user to interactively remove outliers.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("detector", "detector", (Object)new Null());
        this.m_OptionManager.add("col-actual", "columnActual", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("col-predicted", "columnPredicted", (Object)new SpreadSheetColumnIndex("2"));
    }

    public void setDetector(AbstractOutlierDetector value) {
        this.m_Detector = value;
        this.reset();
    }

    public AbstractOutlierDetector getDetector() {
        return this.m_Detector;
    }

    public String detectorTipText() {
        return "The detector to use for the initial outlier detection.";
    }

    public void setColumnActual(SpreadSheetColumnIndex value) {
        this.m_ColumnActual = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumnActual() {
        return this.m_ColumnActual;
    }

    public String columnActualTipText() {
        return "The spreadsheet column with the actual values.";
    }

    public void setColumnPredicted(SpreadSheetColumnIndex value) {
        this.m_ColumnPredicted = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumnPredicted() {
        return this.m_ColumnPredicted;
    }

    public String columnPredictedTipText() {
        return "The spreadsheet column with the predicted values.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"detector", (Object)((Object)this.m_Detector), (String)", detector: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"columnActual", (Object)this.m_ColumnActual, (String)", actual: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"columnPredicted", (Object)this.m_ColumnPredicted, (String)", predicted: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{OutlierContainer.class};
    }

    public void clearPanel() {
        ((XYSequenceContainerManager)((SequencePlotterPanel)this.m_Panel).getContainerManager()).clear();
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_PlotterPanel = new SequencePlotterPanel("Outliers");
        this.m_PlotterPanel.setSidePanelVisible(false);
        AxisPanelOptions axis = new AxisPanelOptions();
        axis.setNthValueToShow(2);
        axis.setTickGenerator((TickGenerator)new FancyTickGenerator());
        axis.setLabel("actual");
        axis.setCustomFormat(new DecimalFormatString("0.0"));
        axis.setTopMargin(0.05);
        axis.setBottomMargin(0.05);
        axis.setWidth(40);
        axis.configure(this.m_PlotterPanel.getPlot(), Axis.BOTTOM);
        axis = new AxisPanelOptions();
        axis.setNthValueToShow(2);
        axis.setTickGenerator((TickGenerator)new FancyTickGenerator());
        axis.setLabel("predicted");
        axis.setCustomFormat(new DecimalFormatString("0.0"));
        axis.setTopMargin(0.05);
        axis.setBottomMargin(0.05);
        axis.setWidth(60);
        axis.configure(this.m_PlotterPanel.getPlot(), Axis.LEFT);
        OutlierPaintlet paintlet = new OutlierPaintlet();
        ToggleOutlier mouseClick = new ToggleOutlier();
        mouseClick.setHitDetector(paintlet.getHitDetector());
        MultiPaintlet overlays = new MultiPaintlet();
        StraightLineOverlayPaintlet diagonal = new StraightLineOverlayPaintlet();
        diagonal.setColor(Color.RED.darker());
        LinearRegressionOverlayPaintlet lrPaintlet = new LinearRegressionOverlayPaintlet();
        lrPaintlet.setOutputSlopeIntercept(true);
        overlays.setSubPaintlets(new XYSequencePaintlet[]{diagonal, lrPaintlet});
        this.m_PlotterPanel.setPaintlet((XYSequencePaintlet)paintlet);
        this.m_PlotterPanel.setMouseClickAction((MouseClickAction)mouseClick);
        this.m_PlotterPanel.setOverlayPaintlet((XYSequencePaintlet)overlays);
        ActorUtils.updateFlowAwarePaintlet((Paintlet)this.m_PlotterPanel.getPaintlet(), (Actor)this);
        result.add((Component)this.m_PlotterPanel, (Object)"Center");
        JPanel panelRight = new JPanel(new BorderLayout());
        panelRight.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        result.add((Component)panelRight, (Object)"East");
        JPanel panelButtonsRight = new JPanel(new GridLayout(3, 1, 5, 5));
        panelRight.add((Component)panelButtonsRight, "North");
        JButton buttonReset = new JButton("Reset", GUIHelper.getIcon((String)"revert.png"));
        buttonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYSequenceContainerManager manager = (XYSequenceContainerManager)RemoveOutliers.this.m_PlotterPanel.getContainerManager();
                if (manager.countVisible() == 0) {
                    return;
                }
                manager.startUpdate();
                XYSequence seq = manager.getVisible(0).getData();
                for (int i = 0; i < seq.size(); ++i) {
                    SequencePlotPoint point = (SequencePlotPoint)seq.toList().get(i);
                    if (!point.hasMetaData() || !point.getMetaData().containsKey(RemoveOutliers.KEY_OUTLIER)) continue;
                    point.getMetaData().put(RemoveOutliers.KEY_OUTLIER, point.getMetaData().containsKey(RemoveOutliers.KEY_INITIAL));
                }
                manager.finishUpdate();
            }
        });
        panelButtonsRight.add(buttonReset);
        JButton buttonClear = new JButton("Clear", GUIHelper.getIcon((String)"new.gif"));
        buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYSequenceContainerManager manager = (XYSequenceContainerManager)RemoveOutliers.this.m_PlotterPanel.getContainerManager();
                if (manager.countVisible() == 0) {
                    return;
                }
                manager.startUpdate();
                XYSequence seq = manager.getVisible(0).getData();
                for (int i = 0; i < seq.size(); ++i) {
                    SequencePlotPoint point = (SequencePlotPoint)seq.toList().get(i);
                    if (!point.hasMetaData() || !point.getMetaData().containsKey(RemoveOutliers.KEY_OUTLIER)) continue;
                    point.getMetaData().put(RemoveOutliers.KEY_OUTLIER, false);
                }
                manager.finishUpdate();
            }
        });
        panelButtonsRight.add(buttonClear);
        JPanel panelBottom = new JPanel(new BorderLayout());
        result.add((Component)panelBottom, (Object)"South");
        JPanel panelButtonsBottom = new JPanel(new FlowLayout(2));
        panelBottom.add((Component)panelButtonsBottom, "East");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoveOutliers.this.m_Accepted = true;
                RemoveOutliers.this.m_Dialog.setVisible(false);
            }
        });
        panelButtonsBottom.add(buttonOK);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.setMnemonic('C');
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoveOutliers.this.m_Accepted = false;
                RemoveOutliers.this.m_Dialog.setVisible(false);
            }
        });
        panelButtonsBottom.add(buttonCancel);
        return result;
    }

    public boolean doInteract() {
        SequencePlotPoint point;
        int i;
        SpreadSheet original = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_ColumnActual.setData((Object)original);
        this.m_ColumnPredicted.setData((Object)original);
        Set<Integer> outlierIndices = this.m_Detector.detect(original, this.m_ColumnActual, this.m_ColumnPredicted);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Outlier indices: " + outlierIndices);
        }
        XYSequenceContainerManager manager = (XYSequenceContainerManager)this.m_PlotterPanel.getContainerManager();
        manager.startUpdate();
        SequencePlotSequence seq = new SequencePlotSequence();
        seq.setComparison(XYSequencePointComparator.Comparison.X_AND_Y);
        seq.setMetaDataKey(KEY_INDEX);
        if (original.hasName()) {
            seq.setID(original.getName());
        } else {
            seq.setID("Pred vs Act");
        }
        XYSequenceContainer cont = manager.newContainer((Comparable)seq);
        manager.add(cont);
        for (i = 0; i < original.getRowCount(); ++i) {
            Double act = original.getCell(i, this.m_ColumnActual.getIntIndex()).toDouble();
            Double pred = original.getCell(i, this.m_ColumnPredicted.getIntIndex()).toDouble();
            if (act == null || pred == null) continue;
            point = new SequencePlotPoint("" + seq.size(), act.doubleValue(), pred.doubleValue());
            point.setMetaData(new HashMap());
            point.getMetaData().put(KEY_INDEX, i);
            if (outlierIndices.contains(i)) {
                point.getMetaData().put(KEY_OUTLIER, true);
                point.getMetaData().put(KEY_INITIAL, true);
            }
            seq.add((DataPoint)point);
        }
        manager.finishUpdate();
        this.m_Accepted = false;
        this.m_Dialog.setVisible(true);
        if (this.m_Accepted) {
            SpreadSheet clean = original.getHeader();
            SpreadSheet outliers = original.getHeader();
            for (i = 0; i < seq.size(); ++i) {
                DataRow row;
                point = (SequencePlotPoint)seq.toList().get(i);
                int index = (Integer)point.getMetaData().get(KEY_INDEX);
                boolean isOutlier = false;
                if (point.getMetaData().containsKey(KEY_OUTLIER)) {
                    isOutlier = (Boolean)point.getMetaData().get(KEY_OUTLIER);
                }
                if (isOutlier) {
                    row = original.getRow(index).getClone(outliers);
                    outliers.addRow().assign((Row)row);
                    continue;
                }
                row = original.getRow(index).getClone(clean);
                clean.addRow().assign((Row)row);
            }
            this.m_OutputToken = new Token((Object)new OutlierContainer(original, clean, outliers));
        }
        return true;
    }
}

