/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.data;

import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetTest;
import adams.env.Environment;
import adams.ml.data.Dataset;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class DatasetTest
extends SpreadSheetTest {
    public DatasetTest(String name) {
        super(name);
    }

    public void textDatasetClone() {
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        reader.setSpreadSheetType((SpreadSheet)new Dataset());
        Dataset data = (Dataset)reader.read(new TmpFile("sample.csv").getAbsolutePath());
        Dataset copy = (Dataset)data.getClone();
        DatasetTest.assertNull((String)"equalHeaders should return null", (Object)data.equalsHeader((SpreadSheet)copy));
        data.setClassAttribute(1, true);
        DatasetTest.assertNotNull((String)"equalHeaders should not return null", (Object)data.equalsHeader((SpreadSheet)copy));
        copy = (Dataset)data.getClone();
        DatasetTest.assertNull((String)"equalHeaders should return null (after setting class attribute)", (Object)data.equalsHeader((SpreadSheet)copy));
    }

    public void testClassAttribute() {
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        reader.setSpreadSheetType((SpreadSheet)new Dataset());
        Dataset data = (Dataset)reader.read(new TmpFile("sample.csv").getAbsolutePath());
        Dataset copy = (Dataset)data.getClone();
        data.setClassAttribute(1, true);
        DatasetTest.assertNotNull((String)"equalHeaders should return a string", (Object)data.equalsHeader((SpreadSheet)copy));
        DatasetTest.assertTrue((String)"col should be a class attribute", (boolean)data.isClassAttribute(1));
        data = (Dataset)copy.getClone();
        String key = data.getHeaderRow().getCellKey(1);
        data.setClassAttribute(key, true);
        DatasetTest.assertNotNull((String)"equalHeaders should return a string", (Object)data.equalsHeader((SpreadSheet)copy));
        DatasetTest.assertTrue((String)"col should be a class attribute", (boolean)data.isClassAttribute(key));
        data = (Dataset)copy.getClone();
        DatasetTest.assertTrue((String)"Failed to update class attribute flag at 0", (boolean)data.setClassAttribute(0, true));
        DatasetTest.assertTrue((String)"Failed to update class attribute flag at 1", (boolean)data.setClassAttribute(1, true));
        DatasetTest.assertFalse((String)"Succeeded to update class attribute flag at 3", (boolean)data.setClassAttribute(3, true));
        DatasetTest.assertNotNull((String)"equalHeaders should return a string", (Object)data.equalsHeader((SpreadSheet)copy));
        DatasetTest.assertTrue((String)"col should be a class attribute", (boolean)data.isClassAttribute(0));
        DatasetTest.assertTrue((String)"col should be a class attribute", (boolean)data.isClassAttribute(1));
        DatasetTest.assertFalse((String)"col should not be a class attribute", (boolean)data.isClassAttribute(3));
        String[] keys = data.getClassAttributeKeys();
        DatasetTest.assertEquals((String)"# of class attributes differ", (int)2, (int)keys.length);
        int[] indices = data.getClassAttributeIndices();
        DatasetTest.assertEquals((String)"# of class attributes differ", (int)2, (int)indices.length);
        DatasetTest.assertEquals((String)"index of class attribute differs", (int)0, (int)indices[0]);
        DatasetTest.assertEquals((String)"index of class attribute differs", (int)1, (int)indices[1]);
        data.removeColumn(0);
        indices = data.getClassAttributeIndices();
        DatasetTest.assertEquals((String)"# of class attributes differ", (int)1, (int)indices.length);
        DatasetTest.assertEquals((String)"index of class attribute differs", (int)0, (int)indices[0]);
    }

    public static Test suite() {
        return new TestSuite(DatasetTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        DatasetTest.runTest((Test)DatasetTest.suite());
    }
}

