/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.ml.data.Dataset;
import adams.ml.data.DefaultDataset;

public class SpreadSheetToDataset
extends AbstractConversion {
    private static final long serialVersionUID = 836034550904607888L;
    protected SpreadSheetColumnRange m_ClassAttribute;

    public String globalInfo() {
        return "Turns a spreadsheet object into a dataset object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("class-attribute", "classAttribute", (Object)new SpreadSheetColumnRange(""));
    }

    public void setClassAttribute(SpreadSheetColumnRange value) {
        this.m_ClassAttribute = value;
        this.reset();
    }

    public SpreadSheetColumnRange getClassAttribute() {
        return this.m_ClassAttribute;
    }

    public String classAttributeTipText() {
        return "The columns to use as class attributes.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"classAttribute", (Object)(this.m_ClassAttribute.getRange().isEmpty() ? "-none-" : this.m_ClassAttribute.getRange()), (String)"class: ");
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return Dataset.class;
    }

    protected Object doConvert() throws Exception {
        int[] indices;
        DefaultDataset result = new DefaultDataset();
        result.assign((SpreadSheet)this.m_Input);
        this.m_ClassAttribute.setData((Object)result);
        for (int index : indices = this.m_ClassAttribute.getIntIndices()) {
            result.setClassAttribute(index, true);
        }
        return result;
    }
}

