/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import adams.ml.data.Dataset;
import adams.ml.data.DefaultDataset;

public class ClassSelector
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = -3019442578354930841L;
    protected SpreadSheetColumnRange m_ClassIndex;
    protected boolean m_Override;
    protected boolean m_Unset;

    public String globalInfo() {
        return "Sets (or unsets) the class index/indices. Can either honour already existing ones or override them.";
    }

    protected void initialize() {
        super.initialize();
        this.m_ClassIndex = new SpreadSheetColumnRange();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("class", "classIndex", (Object)new SpreadSheetColumnRange("last"));
        this.m_OptionManager.add("override", "override", (Object)false);
        this.m_OptionManager.add("unset", "unset", (Object)false);
    }

    public String getQuickInfo() {
        String result;
        if (this.m_Unset || QuickInfoHelper.hasVariable((OptionHandler)this, (String)"unset")) {
            result = QuickInfoHelper.toString((OptionHandler)this, (String)"unset", (boolean)this.m_Unset, (String)"unset");
        } else {
            result = QuickInfoHelper.toString((OptionHandler)this, (String)"classIndex", (Object)this.m_ClassIndex);
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"override", (boolean)this.m_Override, (String)"override", (String)", ");
        }
        return result;
    }

    public void setClassIndex(SpreadSheetColumnRange value) {
        this.m_ClassIndex = value;
        this.reset();
    }

    public SpreadSheetColumnRange getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The attribute(s) to act as class attribute(s).";
    }

    public void setOverride(boolean value) {
        this.m_Override = value;
        this.reset();
    }

    public boolean getOverride() {
        return this.m_Override;
    }

    public String overrideTipText() {
        return "If set to true, then any existing class index will get removed first; otherwise the class index/indices will get added.";
    }

    public void setUnset(boolean value) {
        this.m_Unset = value;
        this.reset();
    }

    public boolean getUnset() {
        return this.m_Unset;
    }

    public String unsetTipText() {
        return "Unsets any class attribute.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{Dataset.class};
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        Dataset data = sheet instanceof Dataset ? (Dataset)sheet : new DefaultDataset(sheet);
        if (this.m_Unset) {
            data.removeClassAttributes();
        } else {
            int[] indices;
            if (this.m_Override) {
                data.removeClassAttributes();
            }
            this.m_ClassIndex.setData((Object)data);
            for (int index : indices = this.m_ClassIndex.getIntIndices()) {
                data.setClassAttribute(index, true);
            }
        }
        this.m_OutputToken = new Token((Object)data);
        this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (Actor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

