/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BinaryMorphology;
import adams.data.image.BooleanArrayMatrixView;
import adams.data.image.moments.MomentHelper;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.statistics.StatUtils;
import adams.flow.container.PredictionEccentricityContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class PredictionEccentricity
extends AbstractTransformer {
    private static final long serialVersionUID = 4894024583214919405L;
    protected SpreadSheetColumnIndex m_Actual;
    protected SpreadSheetColumnIndex m_Predicted;
    protected int m_Grid;
    protected Morphology[] m_Morphologies;
    protected int m_NumCycles;

    public String globalInfo() {
        return "Treats the predictions from a regressor as an image and computes the 'eccentricity' of the actual vs predicted plot. Generated values range from 1 to infinity with a value of 1 representing a circular shape.\nProjects the predictions onto the specified grid, using the 'actual' for both axes.\n\nFor more details see:\nhttps://en.wikipedia.org/wiki/Eccentricity_(mathematics)";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actual", "actual", (Object)new SpreadSheetColumnIndex("Actual"));
        this.m_OptionManager.add("predicted", "predicted", (Object)new SpreadSheetColumnIndex("Predicted"));
        this.m_OptionManager.add("grid", "grid", (Object)100, (Number)1, null);
        this.m_OptionManager.add("morphology", "morphologies", (Object)new Morphology[]{Morphology.DILATE});
        this.m_OptionManager.add("num-cycles", "numCycles", (Object)1, (Number)0, null);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"grid", (Object)this.m_Grid, (String)"grid: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"morphologies", (Object)this.m_Morphologies, (String)", morphologies: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"numCycles", (Object)this.m_NumCycles, (String)", #cycles: ");
        return result;
    }

    public void setActual(SpreadSheetColumnIndex value) {
        this.m_Actual = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getActual() {
        return this.m_Actual;
    }

    public String actualTipText() {
        return "The column with the actual values.";
    }

    public void setPredicted(SpreadSheetColumnIndex value) {
        this.m_Predicted = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getPredicted() {
        return this.m_Predicted;
    }

    public String predictedTipText() {
        return "The column with the predicted values.";
    }

    public void setGrid(int value) {
        if (this.getOptionManager().isValid("grid", (Number)value)) {
            this.m_Grid = value;
            this.reset();
        }
    }

    public int getGrid() {
        return this.m_Grid;
    }

    public String gridTipText() {
        return "The size of the grid to project the predictions onto.";
    }

    public void setMorphologies(Morphology[] value) {
        this.m_Morphologies = value;
        this.reset();
    }

    public Morphology[] getMorphologies() {
        return this.m_Morphologies;
    }

    public String morphologiesTipText() {
        return "The morphologies to apply.";
    }

    public void setNumCycles(int value) {
        if (this.getOptionManager().isValid("numCycles", (Number)value)) {
            this.m_NumCycles = value;
            this.reset();
        }
    }

    public int getNumCycles() {
        return this.m_NumCycles;
    }

    public String numCyclesTipText() {
        return "The number of cycles to apply.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{PredictionEccentricityContainer.class};
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Actual.setData((Object)sheet);
        this.m_Predicted.setData((Object)sheet);
        if (this.m_Actual.getIntIndex() == -1) {
            result = "'actual' column not found? Provided: " + this.m_Actual;
        } else if (this.m_Predicted.getIntIndex() == -1) {
            result = "'predicted' column not found? Provided: " + this.m_Predicted;
        }
        double[] actual = null;
        double[] predicted = null;
        if (result == null && (actual = SpreadSheetUtils.getNumericColumn((SpreadSheet)sheet, (int)this.m_Actual.getIntIndex())).length != (predicted = SpreadSheetUtils.getNumericColumn((SpreadSheet)sheet, (int)this.m_Predicted.getIntIndex())).length) {
            result = "Differing number of actual and predicted values: " + actual.length + " != " + predicted.length;
        }
        if (result == null) {
            int i;
            double min = StatUtils.min(actual);
            double max = StatUtils.max((double[])actual);
            double range = max - min;
            boolean[][] predictions = new boolean[this.m_Grid][this.m_Grid];
            for (i = 0; i < actual.length; ++i) {
                int x = (int)Math.round((actual[i] - min) / range * (double)this.m_Grid);
                int y = this.m_Grid - 1 - (int)Math.round((predicted[i] - min) / range * (double)this.m_Grid);
                if (x < 0 || x >= this.m_Grid || y < 0 || y >= this.m_Grid) continue;
                predictions[y][x] = true;
            }
            for (i = 0; i < this.m_NumCycles; ++i) {
                block6: for (Morphology morphology : this.m_Morphologies) {
                    switch (morphology) {
                        case ERODE: {
                            predictions = BinaryMorphology.erode((boolean[][])predictions);
                            continue block6;
                        }
                        case DILATE: {
                            predictions = BinaryMorphology.dilate((boolean[][])predictions);
                            continue block6;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported morphology: " + (Object)((Object)morphology));
                        }
                    }
                }
            }
            this.m_OutputToken = new Token((Object)new PredictionEccentricityContainer(sheet, MomentHelper.eccentricity((boolean[][])predictions), new BooleanArrayMatrixView(predictions)));
        }
        return result;
    }

    public static enum Morphology {
        ERODE,
        DILATE;

    }
}

