/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.data;

import adams.core.logging.LoggingObject;
import adams.data.spreadsheet.Cell;
import adams.ml.data.Dataset;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DatasetInfo
extends LoggingObject {
    private static final long serialVersionUID = -2693931121026828848L;
    protected Dataset m_Header;
    protected Map<String, Collection<Cell.ContentType>> m_ColumnTypes;
    protected Set<String> m_ClassColumns;

    public DatasetInfo(Dataset data) {
        this.m_Header = data.getHeader();
        this.m_ColumnTypes = new HashMap<String, Collection<Cell.ContentType>>();
        this.m_ClassColumns = new HashSet<String>();
        for (int i = 0; i < data.getColumnCount(); ++i) {
            if (data.isClassAttribute(i)) {
                this.m_ClassColumns.add(data.getColumnName(i));
            }
            this.m_ColumnTypes.put(data.getColumnName(i), data.getContentTypes(i));
        }
    }

    public Dataset getHeader() {
        return this.m_Header;
    }

    public int getColumnCount() {
        return this.m_Header.getColumnCount();
    }

    public Collection<Cell.ContentType> getColumnTypes(int col) {
        return this.m_ColumnTypes.get(this.m_Header.getColumnName(col));
    }

    public Collection<Cell.ContentType> getColumnTypes(String colName) {
        return this.m_ColumnTypes.get(colName);
    }

    public Set<String> getClassColumns() {
        return this.m_ClassColumns;
    }
}

