/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * TrainableFilter.java
 * Copyright (C) 2016 University of Waikato, Hamilton, NZ
 */

package adams.ml.preprocessing;

import adams.ml.data.Dataset;

/**
 * Interface for filters that can be trained/initialized on a batch of data.
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision$
 */
public interface TrainableFilter {

  /**
   * Initializes the filter on the dataset.
   *
   * @param data  	the data to initialize the filter with
   * @throws Exception	if initialization fails
   */
  public void initFilter(Dataset data) throws Exception;
}
