/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.data;

import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.DefaultSpreadSheetTest;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.ml.data.DefaultDataset;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class DefaultDatasetTest
extends DefaultSpreadSheetTest {
    public DefaultDatasetTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("labor.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("labor.csv");
        super.tearDown();
    }

    public void textDatasetClone() {
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        reader.setSpreadSheetType((SpreadSheet)new DefaultDataset());
        DefaultDataset data = (DefaultDataset)reader.read(new TmpFile("sample.csv").getAbsolutePath());
        DefaultDataset copy = (DefaultDataset)data.getClone();
        DefaultDatasetTest.assertNull((String)"equalHeaders should return null", (Object)data.equalsHeader((SpreadSheet)copy));
        data.setClassAttribute(1, true);
        DefaultDatasetTest.assertNotNull((String)"equalHeaders should not return null", (Object)data.equalsHeader((SpreadSheet)copy));
        copy = (DefaultDataset)data.getClone();
        DefaultDatasetTest.assertNull((String)"equalHeaders should return null (after setting class attribute)", (Object)data.equalsHeader((SpreadSheet)copy));
    }

    public void testClassAttribute() {
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        reader.setSpreadSheetType((SpreadSheet)new DefaultDataset());
        DefaultDataset data = (DefaultDataset)reader.read(new TmpFile("sample.csv").getAbsolutePath());
        DefaultDataset copy = (DefaultDataset)data.getClone();
        data.setClassAttribute(1, true);
        DefaultDatasetTest.assertNotNull((String)"equalHeaders should return a string", (Object)data.equalsHeader((SpreadSheet)copy));
        DefaultDatasetTest.assertTrue((String)"col should be a class attribute", (boolean)data.isClassAttribute(1));
        data = (DefaultDataset)copy.getClone();
        String key = data.getHeaderRow().getCellKey(1);
        data.setClassAttribute(key, true);
        DefaultDatasetTest.assertNotNull((String)"equalHeaders should return a string", (Object)data.equalsHeader((SpreadSheet)copy));
        DefaultDatasetTest.assertTrue((String)"col should be a class attribute", (boolean)data.isClassAttribute(key));
        data = (DefaultDataset)copy.getClone();
        DefaultDatasetTest.assertTrue((String)"Failed to update class attribute flag at 0", (boolean)data.setClassAttribute(0, true));
        DefaultDatasetTest.assertTrue((String)"Failed to update class attribute flag at 1", (boolean)data.setClassAttribute(1, true));
        DefaultDatasetTest.assertFalse((String)"Succeeded to update class attribute flag at 3", (boolean)data.setClassAttribute(3, true));
        DefaultDatasetTest.assertNotNull((String)"equalHeaders should return a string", (Object)data.equalsHeader((SpreadSheet)copy));
        DefaultDatasetTest.assertTrue((String)"col should be a class attribute", (boolean)data.isClassAttribute(0));
        DefaultDatasetTest.assertTrue((String)"col should be a class attribute", (boolean)data.isClassAttribute(1));
        DefaultDatasetTest.assertFalse((String)"col should not be a class attribute", (boolean)data.isClassAttribute(3));
        String[] keys = data.getClassAttributeKeys();
        DefaultDatasetTest.assertEquals((String)"# of class attributes differ", (int)2, (int)keys.length);
        int[] indices = data.getClassAttributeIndices();
        DefaultDatasetTest.assertEquals((String)"# of class attributes differ", (int)2, (int)indices.length);
        DefaultDatasetTest.assertEquals((String)"index of class attribute differs", (int)0, (int)indices[0]);
        DefaultDatasetTest.assertEquals((String)"index of class attribute differs", (int)1, (int)indices[1]);
        data.removeColumn(0);
        indices = data.getClassAttributeIndices();
        DefaultDatasetTest.assertEquals((String)"# of class attributes differ", (int)1, (int)indices.length);
        DefaultDatasetTest.assertEquals((String)"index of class attribute differs", (int)0, (int)indices[0]);
    }

    public void testInputs() {
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        reader.setSpreadSheetType((SpreadSheet)new DefaultDataset());
        DefaultDataset data = (DefaultDataset)reader.read(new TmpFile("labor.csv").getAbsolutePath());
        DefaultDataset copy = (DefaultDataset)data.getClone();
        SpreadSheet inputs = data.getInputs();
        DefaultDatasetTest.assertNotNull((String)"input features should not have been null", (Object)inputs);
        data.setClassAttribute(data.getColumnCount() - 1, true);
        inputs = data.getInputs();
        DefaultDatasetTest.assertNotNull((String)"input features should not have been null", (Object)inputs);
        DefaultDatasetTest.assertEquals((String)"input features column count differs", (int)(copy.getColumnCount() - 1), (int)inputs.getColumnCount());
        data.setClassAttribute(data.getColumnCount() - 2, true);
        inputs = data.getInputs();
        DefaultDatasetTest.assertNotNull((String)"input features should not have been null", (Object)inputs);
        DefaultDatasetTest.assertEquals((String)"input features column count differs", (int)(copy.getColumnCount() - 2), (int)inputs.getColumnCount());
    }

    public void testOutputs() {
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        reader.setSpreadSheetType((SpreadSheet)new DefaultDataset());
        DefaultDataset data = (DefaultDataset)reader.read(new TmpFile("labor.csv").getAbsolutePath());
        SpreadSheet outputs = data.getOutputs();
        DefaultDatasetTest.assertNull((String)"output features should have been null", (Object)outputs);
        data.setClassAttribute(data.getColumnCount() - 1, true);
        outputs = data.getOutputs();
        DefaultDatasetTest.assertNotNull((String)"output features should not have been null", (Object)outputs);
        DefaultDatasetTest.assertEquals((String)"output features column count differs", (int)1, (int)outputs.getColumnCount());
        data.setClassAttribute(data.getColumnCount() - 2, true);
        outputs = data.getOutputs();
        DefaultDatasetTest.assertNotNull((String)"output features should not have been null", (Object)outputs);
        DefaultDatasetTest.assertEquals((String)"output features column count differs", (int)2, (int)outputs.getColumnCount());
    }

    public static Test suite() {
        return new TestSuite(DefaultDatasetTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        DefaultDatasetTest.runTest((Test)DefaultDatasetTest.suite());
    }
}

