/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control.removeoutliers;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.statistics.StatUtils;
import adams.flow.control.removeoutliers.AbstractNumericOutlierDetector;
import java.util.HashSet;
import java.util.Set;

public class StdDev
extends AbstractNumericOutlierDetector {
    private static final long serialVersionUID = 6451004929042775852L;
    protected double m_Factor;
    protected boolean m_UseRelative;

    public String globalInfo() {
        return "Standard deviation based detector.\nIf difference between actual/predicted is more than the factor of standard deviations away from the mean, then the point gets flagged as outlier.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("factor", "factor", (Object)2.0, (Number)0.0, null);
        this.m_OptionManager.add("use-relative", "useRelative", (Object)false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"factor", (Object)this.m_Factor, (String)"factor: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"useRelative", (boolean)this.m_UseRelative, (String)"relative", (String)", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public void setFactor(double value) {
        this.m_Factor = value;
        this.reset();
    }

    public double getFactor() {
        return this.m_Factor;
    }

    public String factorTipText() {
        return "The factor which determines whether a value is an outlier.";
    }

    public void setUseRelative(boolean value) {
        this.m_UseRelative = value;
        this.reset();
    }

    public boolean getUseRelative() {
        return this.m_UseRelative;
    }

    public String useRelativeTipText() {
        return "If enabled, relative values (divided by actual) are used instead of absolute ones.";
    }

    @Override
    protected Set<Integer> doDetect(SpreadSheet sheet, SpreadSheetColumnIndex actual, SpreadSheetColumnIndex predicted) {
        int i;
        HashSet<Integer> result = new HashSet<Integer>();
        double[] diff = new double[sheet.getRowCount()];
        Double[] act = this.extractColumn(sheet, actual);
        Double[] pred = this.extractColumn(sheet, predicted);
        for (i = 0; i < sheet.getRowCount(); ++i) {
            if (act[i] != null && pred[i] != null) {
                diff[i] = act[i] - pred[i];
                if (!this.m_UseRelative) continue;
                if (act[i] != 0.0) {
                    int n = i;
                    diff[n] = diff[n] / act[i];
                    continue;
                }
                diff[i] = Double.NaN;
                continue;
            }
            diff[i] = Double.NaN;
        }
        double mean = StatUtils.mean((double[])diff);
        double stdev = StatUtils.stddev((double[])diff, (boolean)true);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("mean=" + mean + ", stdev=" + stdev);
        }
        for (i = 0; i < diff.length; ++i) {
            if (diff[i] > mean + stdev * this.m_Factor) {
                result.add(i);
                continue;
            }
            if (!(diff[i] < mean - stdev * this.m_Factor)) continue;
            result.add(i);
        }
        return result;
    }
}

