/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ConfusionMatrix
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 6499246835313298302L;
    protected SpreadSheetColumnIndex m_ActualColumn;
    protected String m_ActualPrefix;
    protected SpreadSheetColumnIndex m_PredictedColumn;
    protected String m_PredictedPrefix;

    public String globalInfo() {
        return "Generates a confusion matrix from the specified actual and predicted columns containing class labels.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actual-column", "actualColumn", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("actual-prefix", "actualPrefix", (Object)"a: ");
        this.m_OptionManager.add("predicted-column", "predictedColumn", (Object)new SpreadSheetColumnIndex("2"));
        this.m_OptionManager.add("predicted-prefix", "predictedPrefix", (Object)"p: ");
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"actualColumn", (Object)this.m_ActualColumn, (String)"actual: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"predictedColumn", (Object)this.m_PredictedColumn, (String)", predicted: ");
        return result;
    }

    public void setActualColumn(SpreadSheetColumnIndex value) {
        this.m_ActualColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getActualColumn() {
        return this.m_ActualColumn;
    }

    public String actualColumnTipText() {
        return "The column with the actual labels.";
    }

    public void setActualPrefix(String value) {
        this.m_ActualPrefix = value;
        this.reset();
    }

    public String getActualPrefix() {
        return this.m_ActualPrefix;
    }

    public String actualPrefixTipText() {
        return "The prefix for the actual labels.";
    }

    public void setPredictedColumn(SpreadSheetColumnIndex value) {
        this.m_PredictedColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getPredictedColumn() {
        return this.m_PredictedColumn;
    }

    public String predictedColumnTipText() {
        return "The column with the predicted labels.";
    }

    public void setPredictedPrefix(String value) {
        this.m_PredictedPrefix = value;
        this.reset();
    }

    public String getPredictedPrefix() {
        return this.m_PredictedPrefix;
    }

    public String predictedPrefixTipText() {
        return "The prefix for the predicted labels.";
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_ActualColumn.setData((Object)sheet);
        this.m_PredictedColumn.setData((Object)sheet);
        int actCol = this.m_ActualColumn.getIntIndex();
        int predCol = this.m_PredictedColumn.getIntIndex();
        if (actCol == -1) {
            result = "Actual column not found: " + this.m_ActualColumn;
        } else if (predCol == -1) {
            result = "Predicted column not found: " + this.m_PredictedColumn;
        }
        if (result == null) {
            int i;
            HashMap actIndices = new HashMap();
            HashMap predIndices = new HashMap();
            List actLabels = sheet.getCellValues(actCol);
            List predLabels = sheet.getCellValues(predCol);
            for (String label : actLabels) {
                if (predLabels.contains(label)) continue;
                predLabels.add(label);
            }
            for (String label : predLabels) {
                if (actLabels.contains(label)) continue;
                actLabels.add(label);
            }
            Collections.sort(predLabels);
            Collections.sort(actLabels);
            DefaultSpreadSheet matrix = new DefaultSpreadSheet();
            HeaderRow row = matrix.getHeaderRow();
            row.addCell("0").setContentAsString("x");
            for (i = 0; i < predLabels.size(); ++i) {
                row.addCell("" + (i + 1)).setContentAsString(this.m_PredictedPrefix + (String)predLabels.get(i));
                predIndices.put(predLabels.get(i), i + 1);
            }
            for (i = 0; i < actLabels.size(); ++i) {
                row = matrix.addRow();
                for (int n = 0; n < matrix.getColumnCount(); ++n) {
                    row.getCell(n).setContent(Integer.valueOf(0));
                }
                row.addCell(0).setContentAsString(this.m_ActualPrefix + (String)actLabels.get(i));
                actIndices.put(actLabels.get(i), i);
            }
            for (i = 0; i < sheet.getRowCount(); ++i) {
                row = sheet.getRow(i);
                if (!row.hasCell(actCol) || row.getCell(actCol).isMissing() || !row.hasCell(predCol) || row.getCell(predCol).isMissing()) continue;
                String actLabel = row.getCell(actCol).getContent();
                String predLabel = row.getCell(predCol).getContent();
                int actIndex = (Integer)actIndices.get(actLabel);
                int predIndex = (Integer)predIndices.get(predLabel);
                matrix.getCell(actIndex, predIndex).setContent(Long.valueOf(matrix.getCell(actIndex, predIndex).toLong() + 1L));
            }
            this.m_OutputToken = new Token((Object)matrix);
        }
        return result;
    }
}

