/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.capabilities;

import adams.data.spreadsheet.Cell;
import adams.ml.capabilities.Capabilities;
import adams.ml.capabilities.CapabilitiesHandler;
import adams.ml.capabilities.Capability;
import adams.ml.data.Dataset;
import adams.ml.data.DatasetView;
import gnu.trove.list.array.TIntArrayList;
import java.util.Collection;
import java.util.HashSet;

public class CapabilitiesHelper {
    public static Capability contentTypeToCapability(Cell.ContentType type, boolean isClass) {
        if (!isClass) {
            switch (type) {
                case DATE: 
                case DATETIME: 
                case DATETIMEMSEC: 
                case TIME: 
                case TIMEMSEC: {
                    return Capability.DATETYPE_ATTRIBUTE;
                }
                case MISSING: {
                    return Capability.MISSING_ATTRIBUTE_VALUE;
                }
                case BOOLEAN: 
                case STRING: 
                case OBJECT: {
                    return Capability.CATEGORICAL_ATTRIBUTE;
                }
                case LONG: 
                case DOUBLE: {
                    return Capability.NUMERIC_ATTRIBUTE;
                }
            }
            throw new IllegalStateException("Unhandled cell content type: " + type);
        }
        switch (type) {
            case DATE: 
            case DATETIME: 
            case DATETIMEMSEC: 
            case TIME: 
            case TIMEMSEC: {
                return Capability.DATETYPE_CLASS;
            }
            case MISSING: {
                return Capability.MISSING_CLASS_VALUE;
            }
            case BOOLEAN: 
            case STRING: 
            case OBJECT: {
                return Capability.CATEGORICAL_CLASS;
            }
            case LONG: 
            case DOUBLE: {
                return Capability.NUMERIC_CLASS;
            }
        }
        throw new IllegalStateException("Unhandled cell content type: " + type);
    }

    public static Capabilities forDataset(Dataset data, int col) {
        Capabilities result = new Capabilities();
        Collection types = data.getContentTypes(col);
        HashSet<Capability> caps = new HashSet<Capability>();
        for (Cell.ContentType type : types) {
            caps.add(CapabilitiesHelper.contentTypeToCapability(type, data.isClassAttribute(col)));
        }
        if (caps.size() == 1) {
            result.enableAll(caps);
        } else if (caps.size() == 2 && caps.contains((Object)Capability.MISSING_ATTRIBUTE_VALUE)) {
            result.enableAll(caps);
        } else if (caps.size() == 2 && caps.contains((Object)Capability.MISSING_CLASS_VALUE)) {
            result.enableAll(caps);
        } else if (data.isClassAttribute(col)) {
            result.enable(Capability.UNKNOWN_CLASS);
        } else {
            result.enable(Capability.UNKNOWN_ATTRIBUTE);
        }
        return result;
    }

    public static Capabilities forDataset(Dataset data) {
        Capabilities result = new Capabilities();
        for (int i = 0; i < data.getColumnCount(); ++i) {
            result.mergeWith(CapabilitiesHelper.forDataset(data, i));
        }
        return result;
    }

    public static String handles(CapabilitiesHandler handler, Dataset data) {
        return CapabilitiesHelper.handles(handler.getCapabilities(), data);
    }

    public static String handles(Capabilities caps, Dataset data) {
        String result = null;
        Capabilities capsData = CapabilitiesHelper.forDataset(data);
        for (Capability cap : capsData.capabilities()) {
            if (caps.isEnabled(cap)) continue;
            result = "Cannot handle " + (Object)((Object)cap);
            break;
        }
        return result;
    }

    public static String handles(Capabilities caps, Dataset data, int col) {
        String result = null;
        Capabilities capsData = CapabilitiesHelper.forDataset(data, col);
        for (Capability cap : capsData.capabilities()) {
            if (caps.isEnabled(cap)) continue;
            result = "Cannot handle " + (Object)((Object)cap) + ", column " + (col + 1);
            break;
        }
        return result;
    }

    public static Dataset adjust(Dataset data, CapabilitiesHandler handler) throws Exception {
        return CapabilitiesHelper.adjust(data, handler.getCapabilities());
    }

    public static Dataset adjust(Dataset data, Capabilities caps) throws Exception {
        Capabilities capsData = CapabilitiesHelper.forDataset(data);
        HashSet<Capability> hide = new HashSet<Capability>();
        block4: for (Capability cap : capsData.capabilities()) {
            if (caps.isEnabled(cap)) continue;
            if (cap.isClassRelated()) {
                throw new Exception("Adjusting of class-related capabilities not possible: cannpot handle " + (Object)((Object)cap));
            }
            switch (cap) {
                case CATEGORICAL_ATTRIBUTE: 
                case NUMERIC_ATTRIBUTE: 
                case DATETYPE_ATTRIBUTE: {
                    hide.add(cap);
                    continue block4;
                }
                case MISSING_ATTRIBUTE_VALUE: {
                    throw new Exception("Cannot adjust data to handle missing attribute values!");
                }
            }
            throw new Exception("Unhandled capability: " + (Object)((Object)cap));
        }
        if (hide.size() > 0) {
            TIntArrayList visibleCols = new TIntArrayList();
            for (int i = 0; i < data.getColumnCount(); ++i) {
                boolean visible = true;
                Collection types = data.getContentTypes(i);
                for (Cell.ContentType type : types) {
                    if (!hide.contains((Object)CapabilitiesHelper.contentTypeToCapability(type, data.isClassAttribute(i)))) continue;
                    visible = false;
                }
                if (!visible) continue;
                visibleCols.add(i);
            }
            data = new DatasetView(data, null, visibleCols.toArray());
        }
        return data;
    }
}

