/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.data;

import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.ml.data.Dataset;
import adams.ml.data.DatasetView;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class DefaultDataset
extends DefaultSpreadSheet
implements Dataset {
    private static final long serialVersionUID = -6517147329804452995L;
    protected HashSet<String> m_ClassAttributes;

    public DefaultDataset() {
    }

    public DefaultDataset(SpreadSheet sheet) {
        this();
        this.assign(sheet);
    }

    protected void initialize() {
        super.initialize();
        this.m_ClassAttributes = new HashSet();
    }

    public void clear() {
        super.clear();
        this.m_ClassAttributes.clear();
    }

    public void assign(SpreadSheet sheet) {
        super.assign(sheet);
        if (sheet instanceof Dataset) {
            this.m_ClassAttributes.addAll(Arrays.asList(((Dataset)sheet).getClassAttributeKeys()));
        }
    }

    @Override
    public Dataset getClone() {
        DefaultDataset result = (DefaultDataset)super.getClone();
        result.m_ClassAttributes.addAll(this.m_ClassAttributes);
        return result;
    }

    @Override
    public Dataset getHeader() {
        DefaultDataset result = (DefaultDataset)super.getHeader();
        result.m_ClassAttributes.addAll(this.m_ClassAttributes);
        return result;
    }

    @Override
    public int indexOfColumn(String name) {
        return this.getHeaderRow().indexOfContent(name);
    }

    public boolean removeColumn(String columnKey) {
        this.m_ClassAttributes.remove(columnKey);
        return super.removeColumn(columnKey);
    }

    @Override
    public void removeClassAttributes() {
        this.m_ClassAttributes.clear();
    }

    @Override
    public boolean isClassAttribute(String colKey) {
        if (colKey == null) {
            return false;
        }
        return this.m_ClassAttributes.contains(colKey);
    }

    @Override
    public boolean isClassAttribute(int colIndex) {
        if (colIndex > -1) {
            return this.isClassAttribute(this.m_HeaderRow.getCellKey(colIndex));
        }
        return false;
    }

    @Override
    public boolean isClassAttributeByName(String name) {
        return this.isClassAttribute(this.getHeaderRow().indexOfContent(name));
    }

    @Override
    public boolean setClassAttribute(String colKey, boolean isClass) {
        if (colKey == null) {
            return false;
        }
        if (this.getHeaderRow().indexOf(colKey) == -1) {
            return false;
        }
        if (isClass) {
            this.m_ClassAttributes.add(colKey);
        } else {
            this.m_ClassAttributes.remove(colKey);
        }
        return true;
    }

    @Override
    public boolean setClassAttribute(int colIndex, boolean isClass) {
        return this.setClassAttribute(this.m_HeaderRow.getCellKey(colIndex), isClass);
    }

    @Override
    public boolean setClassAttributeByName(String name, boolean isClass) {
        int col = this.indexOfColumn(name);
        return col > -1 && this.setClassAttribute(col, isClass);
    }

    @Override
    public String[] getClassAttributeKeys() {
        return this.m_ClassAttributes.toArray(new String[this.m_ClassAttributes.size()]);
    }

    @Override
    public String[] getClassAttributeNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (int index : this.getClassAttributeIndices()) {
            result.add(this.getColumnName(index));
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public int[] getClassAttributeIndices() {
        String[] keys = this.getClassAttributeKeys();
        int[] result = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            result[i] = this.getHeaderRow().indexOf(keys[i]);
        }
        Arrays.sort(result);
        return result;
    }

    public String equalsHeader(SpreadSheet other) {
        String result = super.equalsHeader(other);
        if (result == null && other instanceof Dataset) {
            int[] otherIndices;
            int[] indices = this.getClassAttributeIndices();
            if (indices.length != (otherIndices = ((Dataset)other).getClassAttributeIndices()).length) {
                result = "Number of class attributes differ: " + indices.length + " != " + otherIndices.length;
            }
            if (result == null) {
                for (int i = 0; i < indices.length; ++i) {
                    if (indices[i] == otherIndices[i]) continue;
                    result = "Class attribute index #" + (i + 1) + " differs: " + (indices[i] + 1) + " != " + (otherIndices[i] + 1);
                    break;
                }
            }
        }
        return result;
    }

    public void mergeWith(SpreadSheet other) {
        int numCols = this.getColumnCount();
        super.mergeWith(other);
        if (other instanceof DefaultDataset) {
            int[] indices = ((DefaultDataset)other).getClassAttributeIndices();
            for (int i = 0; i < indices.length; ++i) {
                this.setClassAttribute(numCols + indices[i], true);
            }
        }
    }

    @Override
    public SpreadSheet getInputs() {
        int i;
        if (this.m_ClassAttributes.size() == 0) {
            return this.getClone();
        }
        if (this.m_ClassAttributes.size() == this.getColumnCount()) {
            return null;
        }
        TIntArrayList indices = new TIntArrayList();
        for (i = 0; i < this.getColumnCount(); ++i) {
            if (this.isClassAttribute(i)) continue;
            indices.add(i);
        }
        SpreadSheet result = this.newInstance();
        HeaderRow newRow = result.getHeaderRow();
        for (i = 0; i < indices.size(); ++i) {
            newRow.addCell("" + i).assign(this.getHeaderRow().getCell(indices.get(i)));
        }
        for (Row row : this.rows()) {
            newRow = result.addRow();
            for (i = 0; i < indices.size(); ++i) {
                if (!row.hasCell(indices.get(i))) continue;
                newRow.addCell(i).assign(row.getCell(indices.get(i)));
            }
        }
        return result;
    }

    @Override
    public SpreadSheet getOutputs() {
        int i;
        if (this.m_ClassAttributes.size() == 0) {
            return null;
        }
        if (this.m_ClassAttributes.size() == this.getColumnCount()) {
            return this.getClone();
        }
        TIntArrayList indices = new TIntArrayList();
        for (i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isClassAttribute(i)) continue;
            indices.add(i);
        }
        SpreadSheet result = this.newInstance();
        HeaderRow newRow = result.getHeaderRow();
        for (i = 0; i < indices.size(); ++i) {
            newRow.addCell("" + i).assign(this.getHeaderRow().getCell(indices.get(i)));
        }
        for (Row row : this.rows()) {
            newRow = result.addRow();
            for (i = 0; i < indices.size(); ++i) {
                if (!row.hasCell(indices.get(i))) continue;
                newRow.addCell(i).assign(row.getCell(indices.get(i)));
            }
        }
        return result;
    }

    public DatasetView toView(int[] rows, int[] columns) {
        return new DatasetView(this, rows, columns);
    }
}

