/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * BatchFilter.java
 * Copyright (C) 2016-2018 University of Waikato, Hamilton, NZ
 */

package adams.ml.preprocessing;

import adams.ml.data.Dataset;

/**
 * Interface for filters that filter data in batches.
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 */
public interface BatchFilter
  extends Filter  {

  /**
   * Filters the dataset coming through.
   *
   * @param data	the data to filter
   * @return		the filtered data
   * @throws Exception	if filtering fails
   */
  public Dataset filter(Dataset data) throws Exception;
}
