/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.model.regression;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.data.io.input.ChunkedSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetHelper;
import adams.ml.data.Dataset;
import adams.ml.data.DefaultDataset;
import adams.ml.model.regression.RegressionModel;
import adams.ml.model.regression.Regressor;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractRegressorTestCase
extends AdamsTestCase {
    public AbstractRegressorTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/ml/model/regression/data");
    }

    protected abstract Regressor getTypicalSetup();

    protected abstract Dataset getTypicalDataset();

    public void testDoesntChangeInput() {
        Dataset data = this.getTypicalDataset();
        Dataset dataCopy = data.getClone();
        Regressor algorithm = this.getTypicalSetup();
        try {
            algorithm.buildModel(data);
        }
        catch (Exception e) {
            AbstractRegressorTestCase.fail((String)("Failed to build model: " + Utils.throwableToString((Throwable)e)));
            return;
        }
        AbstractRegressorTestCase.assertNull((String)"Changed input data", (Object)SpreadSheetHelper.compare((SpreadSheet)dataCopy, (SpreadSheet)data));
    }

    public void testSubsequentBuilds() {
        double[] pred2;
        double[] pred1;
        Dataset data = this.getTypicalDataset();
        Regressor algorithm = this.getTypicalSetup();
        try {
            algorithm.buildModel(data);
            pred1 = this.predict(algorithm, data);
        }
        catch (Exception e) {
            AbstractRegressorTestCase.fail((String)("Failed to build model (1): " + Utils.throwableToString((Throwable)e)));
            return;
        }
        try {
            algorithm.buildModel(data);
            pred2 = this.predict(algorithm, data);
        }
        catch (Exception e) {
            AbstractRegressorTestCase.fail((String)("Failed to build model (1): " + Utils.throwableToString((Throwable)e)));
            return;
        }
        for (int y = 0; y < pred1.length; ++y) {
            if (Double.isNaN(pred1[y]) && Double.isNaN(pred2[y])) continue;
            AbstractRegressorTestCase.assertNotNull((String)("predictions1 at #" + (y + 1) + " are null"), (Object)pred1[y]);
            AbstractRegressorTestCase.assertNotNull((String)("predictions2 at #" + (y + 1) + " are null"), (Object)pred2[y]);
            AbstractRegressorTestCase.assertEquals((String)("Predictions at #" + (y + 1) + " differ"), (Object)pred1[y], (Object)pred2[y]);
        }
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract SpreadSheetReader[] getRegressionInputReaders();

    protected abstract String[] getRegressionInputClasses();

    protected abstract Regressor[] getRegressionSetups();

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    protected Dataset load(String filename, SpreadSheetReader reader, String cls) {
        this.m_TestHelper.copyResourceToTmp(filename);
        SpreadSheet full = reader.read((File)new TmpFile(filename));
        if (reader instanceof ChunkedSpreadSheetReader) {
            while (((ChunkedSpreadSheetReader)reader).hasMoreChunks()) {
                SpreadSheet chunk = ((ChunkedSpreadSheetReader)reader).nextChunk();
                for (Row row : chunk.rows()) {
                    full.addRow().assign(row);
                }
            }
        }
        this.m_TestHelper.deleteFileFromTmp(filename);
        DefaultDataset result = new DefaultDataset(full);
        result.setClassAttributeByName(cls, true);
        return result;
    }

    protected double[] predict(Regressor cls, Dataset data) {
        RegressionModel model;
        double[] result = new double[data.getRowCount()];
        try {
            model = (RegressionModel)cls.buildModel(data);
        }
        catch (Exception e) {
            AbstractRegressorTestCase.fail((String)("Failed to build model on data!\nAlgorithm: " + OptionUtils.getCommandLine((Object)cls) + "\nData:\n" + data));
            return null;
        }
        for (int i = 0; i < data.getRowCount(); ++i) {
            try {
                result[i] = model.classify((Row)data.getRow(i));
                continue;
            }
            catch (Exception e) {
                result[i] = Double.NaN;
            }
        }
        return result;
    }

    protected boolean save(double[] preds, String filename) {
        StringBuilder data = new StringBuilder();
        for (double pred : preds) {
            if (data.length() > 0) {
                data.append("\n");
            }
            data.append(Utils.doubleToString((double)pred, (int)6));
        }
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)data, (boolean)false);
    }

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        SpreadSheetReader[] readers = this.getRegressionInputReaders();
        String[] classes = this.getRegressionInputClasses();
        String[] output = new String[input.length];
        Regressor[] setups = this.getRegressionSetups();
        AbstractRegressorTestCase.assertEquals((String)"Number of files and readers differ!", (int)input.length, (int)readers.length);
        AbstractRegressorTestCase.assertEquals((String)"Number of files and classes differ!", (int)input.length, (int)classes.length);
        AbstractRegressorTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            Dataset data = this.load(input[i], readers[i], classes[i]);
            AbstractRegressorTestCase.assertNotNull((String)"Failed to load data?", (Object)data);
            double[] preds = this.predict(setups[i], data);
            AbstractRegressorTestCase.assertNotNull((String)"Failed to make predictions?", (Object)preds);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(preds, output[i]);
            AbstractRegressorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles, this.getRegressionIgnoredLineIndices());
        AbstractRegressorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            setups[i].destroy();
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

