/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.preprocessing;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.data.io.input.ChunkedSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetHelper;
import adams.ml.data.Dataset;
import adams.ml.data.DefaultDataset;
import adams.ml.preprocessing.BatchFilter;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractFilterTestCase<T extends BatchFilter>
extends AdamsTestCase {
    public AbstractFilterTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/ml/preprocessing/data");
    }

    protected abstract T getTypicalSetup();

    protected abstract Dataset getTypicalDataset();

    public void testDoesntChangeInput() {
        Dataset data = this.getTypicalDataset();
        Dataset dataCopy = data.getClone();
        T algorithm = this.getTypicalSetup();
        try {
            algorithm.filter(data);
        }
        catch (Exception e) {
            AbstractFilterTestCase.fail((String)("Failed to build model: " + Utils.throwableToString((Throwable)e)));
            return;
        }
        AbstractFilterTestCase.assertNull((String)"Changed input data", (Object)SpreadSheetHelper.compare((SpreadSheet)dataCopy, (SpreadSheet)data));
    }

    protected String compareDatasets(Dataset data1, Dataset data2) {
        String result = data1.equalsHeader((SpreadSheet)data2);
        if (result == null && data1.getRowCount() != data2.getRowCount()) {
            result = "# rows differ: " + data1.getRowCount() + " != " + data2.getRowCount();
        }
        if (result == null) {
            for (int i = 0; i < data1.getRowCount(); ++i) {
                DataRow row1 = data1.getRow(i);
                DataRow row2 = data2.getRow(i);
                if (row1.toString().equals(row2.toString())) continue;
                result = "Row #" + (i + 1) + " differs:\nRow1: " + row1 + "\nRow2: " + row2;
                break;
            }
        }
        return result;
    }

    public void testSubsequentFiltering() {
        Dataset filtered2;
        Dataset filtered1;
        Dataset data = this.getTypicalDataset();
        T filter = this.getTypicalSetup();
        try {
            filter.filter(data);
            filtered1 = this.filter(filter, data);
        }
        catch (Exception e) {
            AbstractFilterTestCase.fail((String)("Failed to filter (1): " + Utils.throwableToString((Throwable)e)));
            return;
        }
        try {
            filter.filter(data);
            filtered2 = this.filter(filter, data);
        }
        catch (Exception e) {
            AbstractFilterTestCase.fail((String)("Failed to filter (1): " + Utils.throwableToString((Throwable)e)));
            return;
        }
        AbstractFilterTestCase.assertNull((String)"filtered datasets differ", (Object)this.compareDatasets(filtered1, filtered2));
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract SpreadSheetReader[] getRegressionInputReaders();

    protected abstract String[] getRegressionInputClasses();

    protected abstract T[] getRegressionSetups();

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    protected Dataset load(String filename, SpreadSheetReader reader, String cls) {
        this.m_TestHelper.copyResourceToTmp(filename);
        SpreadSheet full = reader.read((File)new TmpFile(filename));
        if (reader instanceof ChunkedSpreadSheetReader) {
            while (((ChunkedSpreadSheetReader)reader).hasMoreChunks()) {
                SpreadSheet chunk = ((ChunkedSpreadSheetReader)reader).nextChunk();
                for (Row row : chunk.rows()) {
                    full.addRow().assign(row);
                }
            }
        }
        this.m_TestHelper.deleteFileFromTmp(filename);
        DefaultDataset result = new DefaultDataset(full);
        result.setClassAttributeByName(cls, true);
        return result;
    }

    protected Dataset filter(T filter, Dataset data) {
        Dataset result;
        try {
            result = filter.filter(data);
        }
        catch (Exception e) {
            AbstractFilterTestCase.fail((String)("Failed to filter data!\nFilter: " + OptionUtils.getCommandLine(filter) + "\nData:\n" + data));
            return null;
        }
        return result;
    }

    protected boolean save(Dataset filtered, String filename) {
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)filtered.toString(), (boolean)false);
    }

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        SpreadSheetReader[] readers = this.getRegressionInputReaders();
        String[] classes = this.getRegressionInputClasses();
        String[] output = new String[input.length];
        BatchFilter[] setups = this.getRegressionSetups();
        AbstractFilterTestCase.assertEquals((String)"Number of files and readers differ!", (int)input.length, (int)readers.length);
        AbstractFilterTestCase.assertEquals((String)"Number of files and classes differ!", (int)input.length, (int)classes.length);
        AbstractFilterTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            Dataset data = this.load(input[i], readers[i], classes[i]);
            AbstractFilterTestCase.assertNotNull((String)"Failed to load data?", (Object)data);
            Dataset filtered = this.filter(setups[i], data);
            AbstractFilterTestCase.assertNotNull((String)"Failed to filter?", (Object)filtered);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(filtered, output[i]);
            AbstractFilterTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles, this.getRegressionIgnoredLineIndices());
        AbstractFilterTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

