/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control.removeoutliers;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.control.removeoutliers.AbstractOutlierDetector;
import java.util.HashSet;
import java.util.Set;

public class MultiOutlierDetector
extends AbstractOutlierDetector {
    private static final long serialVersionUID = 6451004929042775852L;
    protected AbstractOutlierDetector[] m_Detectors;
    protected Combination m_Combination;

    public String globalInfo() {
        return "Applies the specified outlier detectors sequentially and combines the detected outliers either via union or intersect.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("detector", "detectors", (Object)new AbstractOutlierDetector[0]);
        this.m_OptionManager.add("combination", "combination", (Object)Combination.UNION);
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"combination", (Object)((Object)this.m_Combination));
    }

    public void setDetectors(AbstractOutlierDetector[] value) {
        this.m_Detectors = value;
        this.reset();
    }

    public AbstractOutlierDetector[] getDetectors() {
        return this.m_Detectors;
    }

    public String detectorsTipText() {
        return "The detectors to apply sequentially.";
    }

    public void setCombination(Combination value) {
        this.m_Combination = value;
        this.reset();
    }

    public Combination getCombination() {
        return this.m_Combination;
    }

    public String combinationTipText() {
        return "How to combine the outliers from the various detectors.";
    }

    @Override
    public String check(SpreadSheet sheet, SpreadSheetColumnIndex actual, SpreadSheetColumnIndex predicted) {
        String result = super.check(sheet, actual, predicted);
        if (result == null) {
            for (int i = 0; i < this.m_Detectors.length; ++i) {
                result = this.m_Detectors[i].check(sheet, actual, predicted);
                if (result == null) continue;
                result = "Detector #" + (i + 1) + ": " + result;
                break;
            }
        }
        return result;
    }

    @Override
    protected Set<Integer> doDetect(SpreadSheet sheet, SpreadSheetColumnIndex actual, SpreadSheetColumnIndex predicted) {
        Set<Integer> result = new HashSet<Integer>();
        block4: for (int i = 0; i < this.m_Detectors.length; ++i) {
            Set<Integer> current = this.m_Detectors[i].detect(sheet, actual, predicted);
            if (i == 0) {
                result = current;
                continue;
            }
            switch (this.m_Combination) {
                case INTERSECT: {
                    result.containsAll(current);
                    continue block4;
                }
                case UNION: {
                    result.addAll(current);
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unhandled combination: " + (Object)((Object)this.m_Combination));
                }
            }
        }
        return result;
    }

    public static enum Combination {
        UNION,
        INTERSECT;

    }
}

