/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Row;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import adams.ml.data.Dataset;
import adams.ml.preprocessing.StreamFilter;
import adams.ml.preprocessing.unsupervised.PassThrough;

public class DatasetRowFilter
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = -2575293379884905336L;
    protected StreamFilter m_Filter;
    protected StreamFilter m_ActualFilter;

    public String globalInfo() {
        return "Applies the stream filter to the rows.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new PassThrough());
    }

    protected void reset() {
        super.reset();
        this.m_ActualFilter = null;
    }

    public void setFilter(StreamFilter value) {
        this.m_Filter = value;
        this.reset();
    }

    public StreamFilter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to use for filtering the Dataset rows.";
    }

    public Class[] accepts() {
        return new Class[]{Row.class, Dataset.class};
    }

    public Class[] generates() {
        return new Class[]{Row.class, Dataset.class};
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"filter", (Object)this.m_Filter, (String)"filter: ");
    }

    protected String doExecute() {
        String result = null;
        Row rowIn = null;
        Dataset setIn = null;
        if (this.m_InputToken.hasPayload(Row.class)) {
            rowIn = (Row)this.m_InputToken.getPayload(Row.class);
        } else {
            setIn = (Dataset)this.m_InputToken.getPayload(Dataset.class);
        }
        try {
            if (this.m_ActualFilter == null) {
                this.m_ActualFilter = (StreamFilter)ObjectCopyHelper.copyObject((Object)this.m_Filter);
            }
            if (rowIn != null) {
                Row rowOut = this.m_ActualFilter.filter(rowIn);
                this.m_OutputToken = new Token((Object)rowOut);
            } else {
                Dataset setOut = this.m_ActualFilter.filter(setIn);
                this.m_OutputToken = new Token((Object)setOut);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to filter " + (rowIn != null ? "row" : "dataset") + "!", e);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (Actor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

