/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.generatefilebaseddataset;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.FileWriter;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.container.FileBasedDatasetContainer;
import adams.flow.transformer.generatefilebaseddataset.AbstractFileBasedDatasetGeneration;
import java.io.File;
import java.util.Arrays;

public class SimpleFileList
extends AbstractFileBasedDatasetGeneration<String>
implements FileWriter {
    private static final long serialVersionUID = -770254975357506229L;
    protected String m_Value;
    protected PlaceholderFile m_OutputFile;

    public String globalInfo() {
        return "Simply outputs the specified list of files in the container as a text file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("value", "value", (Object)"Train");
        this.m_OptionManager.add("output-file", "outputFile", (Object)new PlaceholderFile());
    }

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The name of the value in the container to use.";
    }

    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    public String outputFileTipText() {
        return "The file to save the file list to.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"value", (Object)this.m_Value, (String)"value: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputFile", (Object)this.m_OutputFile, (String)", output: ");
        return result;
    }

    @Override
    public Class generates() {
        return String.class;
    }

    @Override
    protected String[] requiredValues() {
        return new String[]{this.m_Value};
    }

    @Override
    protected String check(FileBasedDatasetContainer cont) {
        String result = super.check(cont);
        if (result == null) {
            if (!this.m_OutputFile.exists()) {
                result = "Output file does not exist: " + this.m_OutputFile;
            } else if (this.m_OutputFile.isDirectory()) {
                result = "Output file points to directory: " + this.m_OutputFile;
            }
        }
        return result;
    }

    @Override
    protected String doGenerate(FileBasedDatasetContainer cont) {
        String[] files = (String[])cont.getValue(this.m_Value, String[].class);
        String msg = FileUtils.saveToFileMsg(Arrays.asList(files), (File)this.m_OutputFile, null);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        return this.m_OutputFile.getAbsolutePath();
    }
}

