/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.preparefilebaseddataset;

import adams.core.Randomizable;
import adams.flow.transformer.preparefilebaseddataset.AbstractFileBasedDatasetPreparation;
import gnu.trove.list.array.TIntArrayList;
import java.util.Random;

public abstract class AbstractRandomizableFileBasedDatasetPreparation<T>
extends AbstractFileBasedDatasetPreparation<T>
implements Randomizable {
    private static final long serialVersionUID = -5423856112374249044L;
    protected long m_Seed;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("seed", "seed", (Object)1L);
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for randomizing the data.";
    }

    protected String[] randomize(String[] data) {
        int i;
        Random rand = new Random(this.m_Seed);
        TIntArrayList indices = new TIntArrayList();
        for (i = 0; i < data.length; ++i) {
            indices.add(i);
        }
        indices.shuffle(rand);
        String[] result = new String[data.length];
        for (i = 0; i < indices.size(); ++i) {
            result[i] = data[indices.get(i)];
        }
        return result;
    }
}

