/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.preparefilebaseddataset;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.FileBasedDatasetContainer;
import adams.flow.transformer.preparefilebaseddataset.AbstractRandomizableFileBasedDatasetPreparation;
import java.util.ArrayList;
import java.util.List;

public class CrossValidation
extends AbstractRandomizableFileBasedDatasetPreparation<String[]> {
    private static final long serialVersionUID = 7027794624748574933L;
    protected int m_NumFolds;
    protected int m_ActualNumFolds;
    protected boolean m_Randomize;

    public String globalInfo() {
        return "Generates cross-validation folds.\nIf number of folds is less than 2, leave-one-out is performed.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-folds", "numFolds", (Object)10);
        this.m_OptionManager.add("randomize", "randomize", (Object)true);
    }

    protected void reset() {
        super.reset();
        this.m_ActualNumFolds = -1;
    }

    public void setNumFolds(int value) {
        this.m_NumFolds = value;
        this.reset();
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public String numFoldsTipText() {
        return "The number of folds; use <2 for leave one out (LOO).";
    }

    public int getActualNumFolds() {
        return this.m_ActualNumFolds;
    }

    public void setRandomize(boolean value) {
        this.m_Randomize = value;
        this.reset();
    }

    public boolean getRandomize() {
        return this.m_Randomize;
    }

    public String randomizeTipText() {
        return "If enabled, the data is randomized first.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"numFolds", (Object)this.m_NumFolds, (String)"folds: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"randomize", (boolean)this.m_Randomize, (String)"randomize", (String)", ");
        return result;
    }

    @Override
    public Class accepts() {
        return String[].class;
    }

    @Override
    protected String check(String[] data) {
        String result = super.check(data);
        if (result == null) {
            if (this.m_NumFolds < 2) {
                if (data.length < 2) {
                    result = "At least two files required, provided: " + data.length;
                }
            } else if (data.length < this.m_NumFolds) {
                result = "At least " + this.m_NumFolds + " files required, provided: " + data.length;
            }
        }
        return result;
    }

    @Override
    protected List<FileBasedDatasetContainer> doPrepare(String[] data) {
        ArrayList<FileBasedDatasetContainer> result = new ArrayList<FileBasedDatasetContainer>();
        this.m_ActualNumFolds = this.m_NumFolds < 2 ? data.length : this.m_NumFolds;
        if (this.m_Randomize) {
            data = this.randomize(data);
        }
        if (this.m_ActualNumFolds == data.length) {
            for (int i = 0; i < data.length; ++i) {
                String[] train = new String[data.length - 1];
                int m = 0;
                for (int n = 0; n < data.length; ++n) {
                    if (n != i) continue;
                    train[m] = data[n];
                    ++m;
                }
                String[] test = new String[]{data[i]};
                result.add(new FileBasedDatasetContainer(train, test));
            }
        } else {
            for (int i = 0; i < this.m_NumFolds; ++i) {
                int n;
                int testFrom = (int)Math.round((double)i * ((double)data.length * 1.0 / (double)this.m_NumFolds));
                int testTo = i == this.m_NumFolds - 1 ? data.length : (int)Math.round((double)(i + 1) * ((double)data.length * 1.0 / (double)this.m_NumFolds));
                String[] test = new String[testTo - testFrom];
                for (n = testFrom; n < testTo; ++n) {
                    test[n - testFrom] = data[n];
                }
                String[] train = new String[data.length - test.length];
                int m = 0;
                for (n = 0; n < testFrom; ++n) {
                    train[m] = data[n];
                    ++m;
                }
                for (n = testTo; n < data.length; ++n) {
                    train[m] = data[n];
                    ++m;
                }
                result.add(new FileBasedDatasetContainer(train, test));
            }
        }
        return result;
    }
}

