/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.preparefilebaseddataset;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.FileBasedDatasetContainer;
import adams.flow.transformer.preparefilebaseddataset.AbstractRandomizableFileBasedDatasetPreparation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TrainTestSplit
extends AbstractRandomizableFileBasedDatasetPreparation<String[]> {
    private static final long serialVersionUID = 7027794624748574933L;
    protected double m_Percentage;
    protected boolean m_PreserveOrder;

    public String globalInfo() {
        return "Generates a train/test split.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("percentage", "percentage", (Object)0.66, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("preserve-order", "preserveOrder", (Object)false);
    }

    public void setPercentage(double value) {
        if (this.getOptionManager().isValid("percentage", (Number)value)) {
            this.m_Percentage = value;
            this.reset();
        }
    }

    public double getPercentage() {
        return this.m_Percentage;
    }

    public String percentageTipText() {
        return "The percentage of the data to use for the training set.";
    }

    public void setPreserveOrder(boolean value) {
        this.m_PreserveOrder = value;
        this.reset();
    }

    public boolean getPreserveOrder() {
        return this.m_PreserveOrder;
    }

    public String preserveOrderTipText() {
        return "If enabled, the data doesn't get randomized.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"percentage", (Object)this.m_Percentage, (String)"perc: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"preserveOrder", (boolean)this.m_PreserveOrder, (String)"preserve", (String)", ");
        return result;
    }

    @Override
    public Class accepts() {
        return String[].class;
    }

    @Override
    protected String check(String[] data) {
        String result = super.check(data);
        if (result == null && data.length < 2) {
            result = "At least two files required, provided: " + data.length;
        }
        return result;
    }

    @Override
    protected List<FileBasedDatasetContainer> doPrepare(String[] data) {
        int train;
        if (!this.m_PreserveOrder) {
            data = this.randomize(data);
        }
        if ((train = (int)Math.round((double)data.length * this.m_Percentage)) == data.length) {
            --train;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("# instances for train: " + train);
        }
        FileBasedDatasetContainer cont = new FileBasedDatasetContainer(Arrays.copyOfRange(data, 0, train), Arrays.copyOfRange(data, train, data.length));
        ArrayList<FileBasedDatasetContainer> result = new ArrayList<FileBasedDatasetContainer>();
        result.add(cont);
        return result;
    }
}

