/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.summarystatistics;

import adams.flow.transformer.summarystatistics.AbstractGeneralSummaryStatistic;

public class NoPrediction
extends AbstractGeneralSummaryStatistic {
    private static final long serialVersionUID = 96425796158048162L;

    public String globalInfo() {
        return "Calculates the rows with no prediction.";
    }

    @Override
    public String[] getNames() {
        return new String[]{"No prediction #", "No prediction %"};
    }

    @Override
    protected double[] doCalculate() {
        int total;
        int count = 0;
        if (this.isNumeric()) {
            total = this.m_NumericActual.length;
            for (int i = 0; i < this.m_NumericPredicted.length; ++i) {
                if (!Double.isNaN(this.m_NumericPredicted[i])) continue;
                ++count;
            }
        } else {
            total = this.m_CategoricalActual.length;
            for (int i = 0; i < this.m_CategoricalPredicted.length; ++i) {
                if (!this.m_CategoricalPredicted[i].equals("???")) continue;
                ++count;
            }
        }
        return new double[]{count, count / total};
    }
}

