/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.DateFormat;
import adams.core.Utils;
import adams.data.DateFormatString;
import adams.data.io.input.SimpleArffSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import java.io.BufferedWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;

public class SimpleArffSpreadSheetWriter
extends AbstractSpreadSheetWriter {
    private static final long serialVersionUID = -5681810295868479786L;
    protected int m_MaxNominalValues;
    protected int m_MaxDecimals;
    protected DateFormatString m_DateFormat;
    protected transient DateFormat m_Formatter;

    public String globalInfo() {
        return "Simple writer for Weka ARFF files, only supports NUMERIC, NOMINAL, STRING and DATE attributes.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("max-nominal-values", "maxNominalValues", (Object)25, (Number)0, null);
        this.m_OptionManager.add("max-decimals", "maxDecimals", (Object)6, (Number)0, null);
        this.m_OptionManager.add("date-format", "dateFormat", (Object)this.getDefaultFormat());
    }

    public void setMaxNominalValues(int value) {
        if (this.getOptionManager().isValid("maxNominalValues", (Number)value)) {
            this.m_MaxNominalValues = value;
            this.reset();
        }
    }

    public int getMaxNominalValues() {
        return this.m_MaxNominalValues;
    }

    public String maxNominalValuesTipText() {
        return "The maximum number of different values to accept for NOMINAL attributes before switching to STRING.";
    }

    public void setMaxDecimals(int value) {
        if (this.getOptionManager().isValid("maxDecimals", (Number)value)) {
            this.m_MaxDecimals = value;
            this.reset();
        }
    }

    public int getMaxDecimals() {
        return this.m_MaxDecimals;
    }

    public String maxDecimalsTipText() {
        return "The maximum number of decimals to use for numeric values.";
    }

    protected synchronized DateFormat getFormatter() {
        if (this.m_Formatter == null) {
            this.m_Formatter = this.m_DateFormat.toDateFormat();
        }
        return this.m_Formatter;
    }

    protected DateFormatString getDefaultFormat() {
        return new DateFormatString("yyyy-MM-dd HH:mm:ss");
    }

    public void setDateFormat(DateFormatString value) {
        this.m_DateFormat = value;
        this.reset();
    }

    public DateFormatString getDateFormat() {
        return this.m_DateFormat;
    }

    public String dateFormatTipText() {
        return "The format to use for the date attributes.";
    }

    public SpreadSheetReader getCorrespondingReader() {
        return new SimpleArffSpreadSheetReader();
    }

    public String getFormatDescription() {
        return new SimpleArffSpreadSheetReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new SimpleArffSpreadSheetReader().getFormatExtensions();
    }

    protected AbstractSpreadSheetWriter.OutputType getOutputType() {
        return AbstractSpreadSheetWriter.OutputType.WRITER;
    }

    protected boolean supportsCompressedOutput() {
        return true;
    }

    protected void cleanUpTypes(HashSet<Cell.ContentType> cellTypes) {
        cellTypes.remove(Cell.ContentType.MISSING);
        if (cellTypes.contains(Cell.ContentType.LONG)) {
            cellTypes.remove(Cell.ContentType.LONG);
            cellTypes.add(Cell.ContentType.DOUBLE);
        }
        if (cellTypes.contains(Cell.ContentType.TIME)) {
            cellTypes.remove(Cell.ContentType.TIME);
            cellTypes.add(Cell.ContentType.DATETIMEMSEC);
        }
        if (cellTypes.contains(Cell.ContentType.TIMEMSEC)) {
            cellTypes.remove(Cell.ContentType.TIMEMSEC);
            cellTypes.add(Cell.ContentType.DATETIMEMSEC);
        }
        if (cellTypes.contains(Cell.ContentType.DATE)) {
            cellTypes.remove(Cell.ContentType.DATE);
            cellTypes.add(Cell.ContentType.DATETIMEMSEC);
        }
        if (cellTypes.contains(Cell.ContentType.DATETIME)) {
            cellTypes.remove(Cell.ContentType.DATETIME);
            cellTypes.add(Cell.ContentType.DATETIMEMSEC);
        }
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        boolean result = true;
        BufferedWriter bwriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        try {
            int i;
            String name = content.getName();
            if (name == null) {
                name = "adams";
            }
            bwriter.write("@relation " + Utils.quote((String)name));
            bwriter.newLine();
            bwriter.newLine();
            boolean[] nominal = new boolean[content.getColumnCount()];
            Cell.ContentType[] types = new Cell.ContentType[content.getColumnCount()];
            List[] values = new List[content.getColumnCount()];
            for (i = 0; i < content.getColumnCount(); ++i) {
                HashSet<Cell.ContentType> cellTypes = new HashSet<Cell.ContentType>(content.getContentTypes(i));
                this.cleanUpTypes(cellTypes);
                types[i] = cellTypes.size() == 0 ? Cell.ContentType.DOUBLE : (cellTypes.size() == 1 ? cellTypes.iterator().next() : Cell.ContentType.STRING);
                if (types[i] == Cell.ContentType.STRING) {
                    values[i] = content.getCellValues(i);
                    for (int n = 0; n < values[i].size(); ++n) {
                        values[i].set(n, Utils.quote((String)((String)values[i].get(n))));
                    }
                    if (values[i].size() <= this.m_MaxNominalValues) {
                        nominal[i] = true;
                    }
                }
                bwriter.write("@attribute " + content.getColumnName(i) + " ");
                switch (types[i]) {
                    case STRING: {
                        if (nominal[i]) {
                            bwriter.write("{");
                            bwriter.write(Utils.flatten((List)values[i], (String)","));
                            bwriter.write("}");
                            break;
                        }
                        bwriter.write("string");
                        break;
                    }
                    case DOUBLE: {
                        bwriter.write("numeric");
                        break;
                    }
                    case DATETIMEMSEC: {
                        bwriter.write("date " + Utils.quote((String)this.m_DateFormat.getValue()));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled cell type: " + types[i]);
                    }
                }
                bwriter.newLine();
            }
            bwriter.newLine();
            bwriter.write("@data");
            bwriter.newLine();
            for (Row row : content.rows()) {
                if (this.m_Stopped) {
                    return false;
                }
                block15: for (i = 0; i < content.getColumnCount(); ++i) {
                    Cell cell = row.getCell(i);
                    if (i > 0) {
                        bwriter.write(44);
                    }
                    if (cell != null && !cell.isMissing()) {
                        switch (types[i]) {
                            case STRING: {
                                if (cell.getContent().equals("?")) {
                                    bwriter.write("'?'");
                                    continue block15;
                                }
                                bwriter.write(Utils.quote((String)cell.getContent()));
                                continue block15;
                            }
                            case DOUBLE: {
                                if (cell.isLong()) {
                                    bwriter.write(cell.toLong().toString());
                                    continue block15;
                                }
                                bwriter.write(Utils.doubleToString((double)cell.toDouble(), (int)this.m_MaxDecimals));
                                continue block15;
                            }
                            case DATETIMEMSEC: {
                                bwriter.write(Utils.quote((String)this.getFormatter().format(cell.toAnyDateType())));
                                continue block15;
                            }
                            default: {
                                throw new IllegalStateException("Unhandled cell type: " + types[i]);
                            }
                        }
                    }
                    bwriter.write(63);
                }
                bwriter.newLine();
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to write spreadsheet!", (Throwable)e);
            result = false;
        }
        return result;
    }
}

