/*
 * Decompiled with CFR 0.152.
 */
package adams.data.splitgenerator.generic.randomsplit;

import adams.core.logging.CustomLoggingLevelObject;
import adams.data.binning.Binnable;
import adams.data.binning.operation.Wrapping;
import adams.data.splitgenerator.generic.core.Subset;
import adams.data.splitgenerator.generic.randomization.DefaultRandomization;
import adams.data.splitgenerator.generic.randomization.Randomization;
import adams.data.splitgenerator.generic.randomsplit.SplitPair;
import adams.data.splitgenerator.generic.splitter.DefaultSplitter;
import adams.data.splitgenerator.generic.splitter.Splitter;
import com.github.fracpete.javautils.struct.Struct2;
import gnu.trove.list.TIntList;
import java.util.List;

public class RandomSplitGenerator
extends CustomLoggingLevelObject {
    private static final long serialVersionUID = 1816472926230469853L;
    protected Randomization m_Randomization = new DefaultRandomization();
    protected Splitter m_Splitter = new DefaultSplitter();

    public RandomSplitGenerator() {
        this.reset();
    }

    public void reset() {
        this.m_Randomization.reset();
        this.m_Splitter.reset();
    }

    public void setRandomization(Randomization value) {
        this.m_Randomization = value;
        this.reset();
    }

    public Randomization getRandomization() {
        return this.m_Randomization;
    }

    public void setSplitter(Splitter value) {
        this.m_Splitter = value;
        this.reset();
    }

    public Splitter getSplitter() {
        return this.m_Splitter;
    }

    public <T> SplitPair<Binnable<T>> generate(List<Binnable<T>> data) {
        data = Wrapping.addTmpIndex(data);
        data = this.m_Randomization.randomize(data);
        Struct2 split = this.m_Splitter.split(data);
        TIntList trainIndices = Wrapping.getTmpIndices((List)((List)split.value1));
        Subset train = new Subset((List)split.value1, trainIndices);
        TIntList testIndices = Wrapping.getTmpIndices((List)((List)split.value2));
        Subset test = new Subset((List)split.value2, testIndices);
        Wrapping.removeTmpIndex(data);
        SplitPair<Binnable<T>> result = new SplitPair<Binnable<T>>(train, test);
        return result;
    }
}

