/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control.removeoutliers;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.control.removeoutliers.AbstractOutlierDetector;

public abstract class AbstractNumericOutlierDetector
extends AbstractOutlierDetector {
    private static final long serialVersionUID = 8204585970761312700L;

    @Override
    public String check(SpreadSheet sheet, SpreadSheetColumnIndex actual, SpreadSheetColumnIndex predicted) {
        String result = super.check(sheet, actual, predicted);
        if (result == null) {
            if (!sheet.isNumeric(actual.getIntIndex())) {
                result = "'Actual' column is not numeric: " + actual;
            } else if (!sheet.isNumeric(predicted.getIntIndex())) {
                result = "'Predicted' column is not numeric: " + predicted;
            }
        }
        return result;
    }

    protected Double[] extractColumn(SpreadSheet sheet, SpreadSheetColumnIndex col) {
        Double[] result = new Double[sheet.getRowCount()];
        int index = col.getIntIndex();
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            DataRow row = sheet.getRow(i);
            Double value = null;
            if (row.hasCell(index) && !row.getCell(index).isMissing()) {
                value = row.getCell(index).toDouble();
            }
            result[i] = value;
        }
        return result;
    }
}

