/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control.removeoutliers;

import adams.core.ErrorProvider;
import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import java.util.Set;

public abstract class AbstractOutlierDetector
extends AbstractOptionHandler
implements QuickInfoSupporter,
ErrorProvider {
    private static final long serialVersionUID = -2791096934947903275L;
    protected String m_LastError;

    public String getQuickInfo() {
        return null;
    }

    public boolean hasLastError() {
        return this.m_LastError != null;
    }

    public String getLastError() {
        return this.m_LastError;
    }

    public String check(SpreadSheet sheet, SpreadSheetColumnIndex actual, SpreadSheetColumnIndex predicted) {
        if (sheet == null) {
            return "No spreadsheet provided!";
        }
        actual.setData((Object)sheet);
        if (actual.getIntIndex() == -1) {
            return "'Actual' column not found in spreadsheet: " + actual;
        }
        predicted.setData((Object)sheet);
        if (predicted.getIntIndex() == -1) {
            return "'Predicted' column not found in spreadsheet: " + predicted;
        }
        return null;
    }

    protected abstract Set<Integer> doDetect(SpreadSheet var1, SpreadSheetColumnIndex var2, SpreadSheetColumnIndex var3);

    public Set<Integer> detect(SpreadSheet sheet, SpreadSheetColumnIndex actual, SpreadSheetColumnIndex predicted) {
        this.m_LastError = this.check(sheet, actual, predicted);
        if (this.m_LastError == null) {
            return this.doDetect(sheet, actual, predicted);
        }
        this.getLogger().severe(this.m_LastError);
        return null;
    }
}

