/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.DecimalFormatString;
import adams.data.container.DataPoint;
import adams.data.sequence.XYSequencePointComparator;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetHelper;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.sequenceplotter.ErrorCrossPaintlet;
import adams.flow.sink.sequenceplotter.MouseClickAction;
import adams.flow.sink.sequenceplotter.SequencePlotContainer;
import adams.flow.sink.sequenceplotter.SequencePlotContainerManager;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.flow.sink.sequenceplotter.SequencePlotSequence;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.flow.sink.sequenceplotter.ViewDataClickAction;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.core.AxisPanelOptions;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.CrossPaintlet;
import adams.gui.visualization.sequence.MetaDataColorPaintlet;
import adams.gui.visualization.sequence.MultiPaintlet;
import adams.gui.visualization.sequence.PaintletWithFixedXYRange;
import adams.gui.visualization.sequence.StraightLineOverlayPaintlet;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import adams.gui.visualization.sequence.metadatacolor.AbstractMetaDataColor;
import adams.gui.visualization.sequence.metadatacolor.Dummy;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JComponent;

public class ActualVsPredictedPlot
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
AntiAliasingSupporter {
    private static final long serialVersionUID = -278662766780196125L;
    protected SpreadSheetColumnIndex m_Actual;
    protected SpreadSheetColumnIndex m_Predicted;
    protected SpreadSheetColumnIndex m_Error;
    protected String m_Title;
    protected String m_PlotName;
    protected LimitType m_Limit;
    protected double m_ActualMin;
    protected double m_ActualMax;
    protected double m_PredictedMin;
    protected double m_PredictedMax;
    protected SpreadSheetColumnRange m_Additional;
    protected boolean m_ShowSidePanel;
    protected int m_Diameter;
    protected boolean m_AntiAliasingEnabled;
    protected AbstractMetaDataColor m_MetaDataColor;
    protected XYSequencePaintlet[] m_Overlays;

    public String globalInfo() {
        return "Plots actual vs predicted columns obtained from a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actual", "actual", (Object)new SpreadSheetColumnIndex("Actual"));
        this.m_OptionManager.add("actual-min", "actualMin", (Object)Double.NEGATIVE_INFINITY);
        this.m_OptionManager.add("actual-max", "actualMax", (Object)Double.POSITIVE_INFINITY);
        this.m_OptionManager.add("predicted", "predicted", (Object)new SpreadSheetColumnIndex("Predicted"));
        this.m_OptionManager.add("predicted-min", "predictedMin", (Object)Double.NEGATIVE_INFINITY);
        this.m_OptionManager.add("predicted-max", "predictedMax", (Object)Double.POSITIVE_INFINITY);
        this.m_OptionManager.add("error", "error", (Object)new SpreadSheetColumnIndex(""));
        this.m_OptionManager.add("additional", "additional", (Object)new SpreadSheetColumnRange(""));
        this.m_OptionManager.add("title", "title", (Object)"");
        this.m_OptionManager.add("plot-name", "plotName", (Object)"");
        this.m_OptionManager.add("limit", "limit", (Object)LimitType.NONE);
        this.m_OptionManager.add("show-side-panel", "showSidePanel", (Object)true);
        this.m_OptionManager.add("diameter", "diameter", (Object)7, (Number)1, null);
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
        this.m_OptionManager.add("meta-data-color", "metaDataColor", (Object)new Dummy());
        this.m_OptionManager.add("overlay", "overlays", (Object)new XYSequencePaintlet[]{new StraightLineOverlayPaintlet()});
    }

    protected int getDefaultWidth() {
        return 800;
    }

    protected int getDefaultHeight() {
        return 350;
    }

    public void setActual(SpreadSheetColumnIndex value) {
        this.m_Actual = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getActual() {
        return this.m_Actual;
    }

    public String actualTipText() {
        return "The column with the actual values.";
    }

    public void setActualMin(double value) {
        this.m_ActualMin = value;
        this.reset();
    }

    public double getActualMin() {
        return this.m_ActualMin;
    }

    public String actualMinTipText() {
        return "The minimum to use for the display of the actual axis; use NaN for unlimited.";
    }

    public void setActualMax(double value) {
        this.m_ActualMax = value;
        this.reset();
    }

    public double getActualMax() {
        return this.m_ActualMax;
    }

    public String actualMaxTipText() {
        return "The maximum to use for the display of the actual axis; use NaN for unlimited.";
    }

    public void setPredicted(SpreadSheetColumnIndex value) {
        this.m_Predicted = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getPredicted() {
        return this.m_Predicted;
    }

    public String predictedTipText() {
        return "The column with the predicted values.";
    }

    public void setPredictedMin(double value) {
        this.m_PredictedMin = value;
        this.reset();
    }

    public double getPredictedMin() {
        return this.m_PredictedMin;
    }

    public String predictedMinTipText() {
        return "The minimum to use for the display of the predicted axis; use NaN for unlimited.";
    }

    public void setPredictedMax(double value) {
        this.m_PredictedMax = value;
        this.reset();
    }

    public double getPredictedMax() {
        return this.m_PredictedMax;
    }

    public String predictedMaxTipText() {
        return "The maximum to use for the display of the predicted axis; use NaN for unlimited.";
    }

    public void setError(SpreadSheetColumnIndex value) {
        this.m_Error = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getError() {
        return this.m_Error;
    }

    public String errorTipText() {
        return "The column with the error values.";
    }

    public void setAdditional(SpreadSheetColumnRange value) {
        this.m_Additional = value;
        this.reset();
    }

    public SpreadSheetColumnRange getAdditional() {
        return this.m_Additional;
    }

    public String additionalTipText() {
        return "The additional columns to add to the plot containers.";
    }

    public void setTitle(String value) {
        this.m_Title = value;
        this.reset();
    }

    public String getTitle() {
        return this.m_Title;
    }

    public String titleTipText() {
        return "The (optional) title of the plot.";
    }

    public void setPlotName(String value) {
        this.m_PlotName = value;
        this.reset();
    }

    public String getPlotName() {
        return this.m_PlotName;
    }

    public String plotNameTipText() {
        return "The (optional) name for the plot.";
    }

    public void setLimit(LimitType value) {
        this.m_Limit = value;
        this.reset();
    }

    public LimitType getLimit() {
        return this.m_Limit;
    }

    public String limitTipText() {
        return "The type of limit to impose on the axes; NONE just uses the range determined from the data; ACTUAL uses the min/max from the actual column for both axes; SPECIFIED uses the specified limits or, if a value is 'infinity' then the corresponding value from the determine range.";
    }

    public void setShowSidePanel(boolean value) {
        this.m_ShowSidePanel = value;
        this.reset();
    }

    public boolean getShowSidePanel() {
        return this.m_ShowSidePanel;
    }

    public String showSidePanelTipText() {
        return "If enabled, the side panel gets displayed which allows access to the underlying data for the plot.";
    }

    public void setDiameter(int value) {
        if (this.getOptionManager().isValid("diameter", (Number)value)) {
            this.m_Diameter = value;
            this.reset();
        }
    }

    public int getDiameter() {
        return this.m_Diameter;
    }

    public String diameterTipText() {
        return "The diameter of the cross in pixels (if no error data supplied).";
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.reset();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing.";
    }

    public void setMetaDataColor(AbstractMetaDataColor value) {
        this.m_MetaDataColor = value;
        this.reset();
    }

    public AbstractMetaDataColor getMetaDataColor() {
        return this.m_MetaDataColor;
    }

    public String metaDataColorTipText() {
        return "The scheme to use for extracting the color from the meta-data; ignored if " + Dummy.class.getName() + ".";
    }

    public void setOverlays(XYSequencePaintlet[] value) {
        this.m_Overlays = value;
        this.reset();
    }

    public XYSequencePaintlet[] getOverlays() {
        return this.m_Overlays;
    }

    public String overlaysTipText() {
        return "The overlays to use in the plot.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"actual", (Object)this.m_Actual, (String)", actual: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"predicted", (Object)this.m_Predicted, (String)", predicted: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"error", (Object)(this.m_Error.isEmpty() ? "-none-" : this.m_Error), (String)", error: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"additional", (Object)(this.m_Additional.isEmpty() ? "-none-" : this.m_Additional), (String)", additional: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"plotName", (Object)(this.m_PlotName.isEmpty() ? "-default-" : this.m_PlotName), (String)", name: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"limit", (Object)((Object)this.m_Limit), (String)", limit: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"diameter", (Object)this.m_Diameter, (String)", diameter: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"metaDataColor", (Object)this.m_MetaDataColor, (String)", meta-color: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected AxisPanelOptions getDefaultAxisX() {
        AxisPanelOptions result = new AxisPanelOptions();
        result.setType(Type.DEFAULT);
        result.setLabel("Actual");
        result.setShowGridLines(true);
        result.setLengthTicks(4);
        result.setNthValueToShow(2);
        result.setWidth(40);
        result.setTopMargin(0.0);
        result.setBottomMargin(0.0);
        result.setCustomFormat(new DecimalFormatString("0.0"));
        FancyTickGenerator tick = new FancyTickGenerator();
        tick.setNumTicks(20);
        result.setTickGenerator((TickGenerator)tick);
        return result;
    }

    protected AxisPanelOptions getDefaultAxisY() {
        AxisPanelOptions result = new AxisPanelOptions();
        result.setType(Type.DEFAULT);
        result.setLabel("Predicted");
        result.setShowGridLines(true);
        result.setLengthTicks(4);
        result.setNthValueToShow(2);
        result.setWidth(60);
        result.setTopMargin(0.0);
        result.setBottomMargin(0.0);
        result.setCustomFormat(new DecimalFormatString("0.0"));
        FancyTickGenerator tick = new FancyTickGenerator();
        tick.setNumTicks(10);
        result.setTickGenerator((TickGenerator)tick);
        return result;
    }

    protected BasePanel newPanel() {
        CrossPaintlet paintlet;
        SequencePlotterPanel result = new SequencePlotterPanel("act vs pred");
        if (this.m_Error.isEmpty()) {
            paintlet = new CrossPaintlet();
            paintlet.setDiameter(this.m_Diameter);
        } else {
            paintlet = new ErrorCrossPaintlet();
            ((ErrorCrossPaintlet)paintlet).setDiameter(this.m_Diameter);
        }
        if (paintlet instanceof AntiAliasingSupporter) {
            ((AntiAliasingSupporter)paintlet).setAntiAliasingEnabled(this.m_AntiAliasingEnabled);
        }
        if (paintlet instanceof MetaDataColorPaintlet) {
            ((MetaDataColorPaintlet)paintlet).setMetaDataColor((AbstractMetaDataColor)OptionUtils.shallowCopy((Object)this.m_MetaDataColor));
        }
        PaintletWithFixedXYRange fixedPaintlet = new PaintletWithFixedXYRange();
        fixedPaintlet.setPaintlet((XYSequencePaintlet)paintlet);
        result.setDataPaintlet((Paintlet)fixedPaintlet);
        ActorUtils.updateFlowAwarePaintlet((Paintlet)result.getDataPaintlet(), (Actor)this);
        MultiPaintlet overlays = new MultiPaintlet();
        overlays.setSubPaintlets((XYSequencePaintlet[])OptionUtils.shallowCopy((Object[])this.m_Overlays));
        result.setOverlayPaintlet((XYSequencePaintlet)overlays);
        ActorUtils.updateFlowAwarePaintlet((Paintlet)result.getOverlayPaintlet(), (Actor)this);
        this.getDefaultAxisX().configure(result.getPlot(), Axis.BOTTOM);
        this.getDefaultAxisY().configure(result.getPlot(), Axis.LEFT);
        result.setColorProvider((ColorProvider)new DefaultColorProvider());
        result.setSidePanelVisible(this.m_ShowSidePanel);
        result.setMouseClickAction((MouseClickAction)new ViewDataClickAction());
        result.getPlot().clearToolTipAxes();
        result.getPlot().setTipTextCustomizer(null);
        return result;
    }

    public void clearPanel() {
        if (this.m_Panel != null) {
            ((XYSequenceContainerManager)((SequencePlotterPanel)this.m_Panel).getContainerManager()).clear();
        }
    }

    protected void addData(SequencePlotterPanel panel, SpreadSheet sheet) {
        PaintletWithFixedXYRange paintlet = (PaintletWithFixedXYRange)panel.getDataPaintlet();
        SequencePlotContainerManager manager = (SequencePlotContainerManager)panel.getContainerManager();
        this.m_Actual.setData((Object)sheet);
        if (this.m_Actual.getIntIndex() == -1) {
            throw new IllegalStateException("'Actual' column not found: " + this.m_Actual);
        }
        this.m_Predicted.setData((Object)sheet);
        if (this.m_Predicted.getIntIndex() == -1) {
            throw new IllegalStateException("'Predicted' column not found: " + this.m_Predicted);
        }
        double[] error = null;
        if (!this.m_Error.isEmpty()) {
            this.m_Error.setData((Object)sheet);
            if (this.m_Error.getIntIndex() == -1) {
                throw new IllegalStateException("'Error' column not found: " + this.m_Error);
            }
        }
        int[] additional = new int[]{};
        if (!this.m_Additional.isEmpty()) {
            this.m_Additional.setData((Object)sheet);
            additional = this.m_Additional.getIntIndices();
        }
        String id = !this.m_PlotName.isEmpty() ? this.m_PlotName : (sheet.hasName() ? sheet.getName() : "act vs pred");
        double[] act = SpreadSheetHelper.getNumericColumn((SpreadSheet)sheet, (int)this.m_Actual.getIntIndex());
        double[] pred = SpreadSheetHelper.getNumericColumn((SpreadSheet)sheet, (int)this.m_Predicted.getIntIndex());
        if (!this.m_Error.isEmpty()) {
            error = SpreadSheetHelper.getNumericColumn((SpreadSheet)sheet, (int)this.m_Error.getIntIndex());
        }
        SequencePlotSequence seq = new SequencePlotSequence();
        seq.setComparison(XYSequencePointComparator.Comparison.X_AND_Y);
        double actMin = Double.POSITIVE_INFINITY;
        double actMax = Double.NEGATIVE_INFINITY;
        double predMin = Double.POSITIVE_INFINITY;
        double predMax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < act.length; ++i) {
            if (Double.isNaN(act[i]) || Double.isNaN(pred[i]) || error != null && Double.isNaN(error[i])) continue;
            actMin = Math.min(actMin, act[i]);
            actMax = Math.max(actMax, act[i]);
            predMin = Math.min(predMin, pred[i]);
            predMax = Math.max(predMax, pred[i]);
            SequencePlotPoint point = error == null ? new SequencePlotPoint(id, act[i], pred[i]) : new SequencePlotPoint(id, act[i], pred[i], null, new Double[]{error[i]});
            if (additional.length > 0) {
                HashMap<String, Object> meta = new HashMap<String, Object>();
                for (int index : additional) {
                    Cell cell;
                    if (!sheet.hasCell(i, index) || (cell = sheet.getCell(i, index)).isMissing()) continue;
                    meta.put(sheet.getColumnName(index), cell.getNative());
                }
                if (meta.size() > 0) {
                    point.setMetaData(meta);
                }
            }
            seq.add((DataPoint)point);
        }
        switch (this.m_Limit) {
            case NONE: {
                paintlet.setMinX(actMin);
                paintlet.setMaxX(actMax);
                paintlet.setMinY(predMin);
                paintlet.setMaxY(predMax);
                break;
            }
            case ACTUAL: {
                paintlet.setMinX(actMin);
                paintlet.setMaxX(actMax);
                paintlet.setMinY(actMin);
                paintlet.setMaxY(actMax);
                break;
            }
            case SPECIFIED: {
                paintlet.setMinX(Double.isInfinite(this.m_ActualMin) ? actMin : this.m_ActualMin);
                paintlet.setMaxX(Double.isInfinite(this.m_ActualMax) ? actMax : this.m_ActualMax);
                paintlet.setMinY(Double.isInfinite(this.m_PredictedMin) ? predMin : this.m_PredictedMin);
                paintlet.setMaxY(Double.isInfinite(this.m_PredictedMax) ? predMax : this.m_PredictedMax);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled limit type: " + (Object)((Object)this.m_Limit));
            }
        }
        SequencePlotContainer cont = manager.newContainer((Comparable)seq);
        cont.setID(id);
        ((XYSequenceContainerManager)panel.getContainerManager()).add((XYSequenceContainer)cont);
    }

    protected void display(Token token) {
        if (!this.m_Title.isEmpty() && !((SequencePlotterPanel)this.m_Panel).getTitle().equals(this.m_Title)) {
            ((SequencePlotterPanel)this.m_Panel).setTitle(this.m_Title);
        }
        this.addData((SequencePlotterPanel)this.m_Panel, (SpreadSheet)token.getPayload());
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = 4356468458332186521L;
            protected SequencePlotterPanel m_Panel;

            protected void initGUI() {
                CrossPaintlet paintlet;
                super.initGUI();
                this.m_Panel = new SequencePlotterPanel("act vs pred");
                if (ActualVsPredictedPlot.this.m_Error.isEmpty()) {
                    paintlet = new CrossPaintlet();
                    paintlet.setDiameter(ActualVsPredictedPlot.this.m_Diameter);
                } else {
                    paintlet = new ErrorCrossPaintlet();
                    ((ErrorCrossPaintlet)paintlet).setDiameter(ActualVsPredictedPlot.this.m_Diameter);
                }
                if (paintlet instanceof AntiAliasingSupporter) {
                    ((AntiAliasingSupporter)paintlet).setAntiAliasingEnabled(ActualVsPredictedPlot.this.m_AntiAliasingEnabled);
                }
                if (paintlet instanceof MetaDataColorPaintlet) {
                    ((MetaDataColorPaintlet)paintlet).setMetaDataColor((AbstractMetaDataColor)ObjectCopyHelper.copyObject((Object)ActualVsPredictedPlot.this.m_MetaDataColor));
                }
                PaintletWithFixedXYRange fixedPaintlet = new PaintletWithFixedXYRange();
                fixedPaintlet.setPaintlet((XYSequencePaintlet)paintlet);
                this.m_Panel.setDataPaintlet((Paintlet)fixedPaintlet);
                ActorUtils.updateFlowAwarePaintlet((Paintlet)this.m_Panel.getDataPaintlet(), (Actor)ActualVsPredictedPlot.this);
                MultiPaintlet overlays = new MultiPaintlet();
                overlays.setSubPaintlets((XYSequencePaintlet[])ObjectCopyHelper.copyObjects((Object[])ActualVsPredictedPlot.this.m_Overlays));
                this.m_Panel.setOverlayPaintlet((XYSequencePaintlet)overlays);
                ActorUtils.updateFlowAwarePaintlet((Paintlet)this.m_Panel.getOverlayPaintlet(), (Actor)ActualVsPredictedPlot.this);
                ActualVsPredictedPlot.this.getDefaultAxisX().configure(this.m_Panel.getPlot(), Axis.BOTTOM);
                ActualVsPredictedPlot.this.getDefaultAxisY().configure(this.m_Panel.getPlot(), Axis.LEFT);
                this.m_Panel.setColorProvider((ColorProvider)new DefaultColorProvider());
                this.m_Panel.setSidePanelVisible(ActualVsPredictedPlot.this.m_ShowSidePanel);
                this.m_Panel.setMouseClickAction((MouseClickAction)new ViewDataClickAction());
                this.m_Panel.getPlot().clearToolTipAxes();
                this.m_Panel.getPlot().setTipTextCustomizer(null);
                this.add((Component)this.m_Panel, "Center");
            }

            public void display(Token token) {
                if (!ActualVsPredictedPlot.this.m_Title.isEmpty() && !this.m_Panel.getTitle().equals(ActualVsPredictedPlot.this.m_Title)) {
                    this.m_Panel.setTitle(ActualVsPredictedPlot.this.m_Title);
                }
                ActualVsPredictedPlot.this.addData(this.m_Panel, (SpreadSheet)token.getPayload());
            }

            public void clearPanel() {
                ((XYSequenceContainerManager)this.m_Panel.getContainerManager()).clear();
            }

            public void cleanUp() {
                ((XYSequenceContainerManager)this.m_Panel.getContainerManager()).clear();
            }

            public JComponent supplyComponent() {
                return this.m_Panel;
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    public static enum LimitType {
        NONE,
        ACTUAL,
        SPECIFIED;

    }
}

