/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ObjectCopyHelper;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.ml.data.Dataset;
import adams.ml.preprocessing.BatchFilter;
import adams.ml.preprocessing.unsupervised.PassThrough;

public class DatasetFilter
extends AbstractTransformer {
    private static final long serialVersionUID = -2575293379884905336L;
    protected BatchFilter m_Filter;
    protected BatchFilter m_ActualFilter;

    public String globalInfo() {
        return "Applies the batch filter to the dataset.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new PassThrough());
    }

    protected void reset() {
        super.reset();
        this.m_ActualFilter = null;
    }

    public void setFilter(BatchFilter value) {
        this.m_Filter = value;
        this.reset();
    }

    public BatchFilter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to use for filtering the Dataset objects.";
    }

    public Class[] accepts() {
        return new Class[]{Dataset.class};
    }

    public Class[] generates() {
        return new Class[]{Dataset.class};
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"filter", (Object)this.m_Filter, (String)"filter: ");
    }

    protected String doExecute() {
        String result = null;
        Dataset data = (Dataset)this.m_InputToken.getPayload(Dataset.class);
        try {
            if (this.m_ActualFilter == null) {
                this.m_ActualFilter = (BatchFilter)ObjectCopyHelper.copyObject((Object)this.m_Filter);
            }
            Dataset filtered = this.m_ActualFilter.filter(data);
            this.m_OutputToken = new Token((Object)filtered);
        }
        catch (Exception e) {
            result = this.handleException("Failed to filter dataset!", e);
        }
        return result;
    }
}

