/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.FileBasedDatasetContainer;
import adams.flow.control.SetContainerValue;
import adams.flow.transformer.AbstractArrayProvider;
import adams.flow.transformer.GenerateFileBasedDataset;
import adams.flow.transformer.preparefilebaseddataset.AbstractFileBasedDatasetPreparation;
import adams.flow.transformer.preparefilebaseddataset.TrainTestSplit;
import java.util.List;

public class PrepareFileBasedDataset
extends AbstractArrayProvider
implements ClassCrossReference {
    private static final long serialVersionUID = -5135595330787325026L;
    protected AbstractFileBasedDatasetPreparation m_Preparation;

    public String globalInfo() {
        return "Processes the incoming files and generates a dataset container.";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{SetContainerValue.class, GenerateFileBasedDataset.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("preparation", "preparation", (Object)new TrainTestSplit());
    }

    public String outputArrayTipText() {
        return "If enabled, outputs the containers as array rather than one-by-one.";
    }

    public void setPreparation(AbstractFileBasedDatasetPreparation value) {
        this.m_Preparation = value;
        this.reset();
    }

    public AbstractFileBasedDatasetPreparation getPreparation() {
        return this.m_Preparation;
    }

    public String preparationTipText() {
        return "The preparation scheme to apply to the files.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"preparation", (Object)((Object)this.m_Preparation));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (Object)(this.m_OutputArray ? "as array" : "one-by-one"), (String)", ");
        return result;
    }

    protected Class getItemClass() {
        return FileBasedDatasetContainer.class;
    }

    public Class[] accepts() {
        return new Class[]{this.m_Preparation.accepts()};
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue.clear();
        try {
            List<FileBasedDatasetContainer> conts = this.m_Preparation.prepare(this.m_InputToken.getPayload());
            this.m_Queue.addAll(conts);
        }
        catch (Exception e) {
            result = this.handleException("Failed to prepare files!", e);
        }
        return result;
    }
}

