/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.preparefilebaseddataset;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.binning.operation.Wrapping;
import adams.data.splitgenerator.generic.randomization.DefaultRandomization;
import adams.data.splitgenerator.generic.randomization.PassThrough;
import adams.data.splitgenerator.generic.randomsplit.RandomSplitGenerator;
import adams.data.splitgenerator.generic.randomsplit.SplitPair;
import adams.data.splitgenerator.generic.splitter.DefaultSplitter;
import adams.flow.container.FileBasedDatasetContainer;
import adams.flow.transformer.preparefilebaseddataset.AbstractRandomizableFileBasedDatasetPreparation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TrainTestSplit
extends AbstractRandomizableFileBasedDatasetPreparation<String[]> {
    private static final long serialVersionUID = 7027794624748574933L;
    protected double m_Percentage;
    protected boolean m_PreserveOrder;

    public String globalInfo() {
        return "Generates a train/test split.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("percentage", "percentage", (Object)0.66, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("preserve-order", "preserveOrder", (Object)false);
    }

    public void setPercentage(double value) {
        if (this.getOptionManager().isValid("percentage", (Number)value)) {
            this.m_Percentage = value;
            this.reset();
        }
    }

    public double getPercentage() {
        return this.m_Percentage;
    }

    public String percentageTipText() {
        return "The percentage of the data to use for the training set.";
    }

    public void setPreserveOrder(boolean value) {
        this.m_PreserveOrder = value;
        this.reset();
    }

    public boolean getPreserveOrder() {
        return this.m_PreserveOrder;
    }

    public String preserveOrderTipText() {
        return "If enabled, the data doesn't get randomized.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"percentage", (Object)this.m_Percentage, (String)"perc: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"preserveOrder", (boolean)this.m_PreserveOrder, (String)"preserve", (String)", ");
        return result;
    }

    @Override
    public Class accepts() {
        return String[].class;
    }

    @Override
    protected String check(String[] data) {
        String result = super.check(data);
        if (result == null && data.length < 2) {
            result = "At least two files required, provided: " + data.length;
        }
        return result;
    }

    @Override
    protected List<FileBasedDatasetContainer> doPrepare(String[] data) {
        List binnable;
        RandomSplitGenerator generator = new RandomSplitGenerator();
        DefaultSplitter splitter = new DefaultSplitter();
        splitter.setPercentage(this.m_Percentage);
        generator.setSplitter(splitter);
        if (!this.m_PreserveOrder) {
            DefaultRandomization defRand = new DefaultRandomization();
            defRand.setSeed(this.m_Seed);
            defRand.setLoggingLevel(this.m_LoggingLevel);
            generator.setRandomization(defRand);
        } else {
            generator.setRandomization(new PassThrough());
        }
        try {
            binnable = Wrapping.wrap(Arrays.asList(data), (Wrapping.BinValueExtractor)new Wrapping.IndexedBinValueExtractor());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to wrap file names in Binnable objects!");
        }
        SplitPair pair = generator.generate(binnable);
        String[] train = Wrapping.unwrap(pair.getTrain().getData()).toArray(new String[0]);
        String[] test = Wrapping.unwrap(pair.getTest().getData()).toArray(new String[0]);
        FileBasedDatasetContainer cont = new FileBasedDatasetContainer(train, test);
        ArrayList<FileBasedDatasetContainer> result = new ArrayList<FileBasedDatasetContainer>();
        result.add(cont);
        return result;
    }
}

