/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.summarystatistics;

import adams.flow.transformer.summarystatistics.AbstractSummaryStatistic;
import adams.flow.transformer.summarystatistics.NumericSummaryStatistic;

public abstract class AbstractNumericSummaryStatistic
extends AbstractSummaryStatistic
implements NumericSummaryStatistic {
    private static final long serialVersionUID = -3184846086560157381L;
    protected double[] m_NumericActual;
    protected double[] m_NumericPredicted;

    @Override
    public void clear() {
        super.clear();
        this.m_NumericActual = null;
        this.m_NumericPredicted = null;
    }

    @Override
    public void setNumericActual(double[] value) {
        this.m_NumericActual = value;
    }

    @Override
    public double[] getNumericActual() {
        return this.m_NumericActual;
    }

    @Override
    public void setNumericPredicted(double[] value) {
        this.m_NumericPredicted = value;
    }

    @Override
    public double[] getNumericPredicted() {
        return this.m_NumericPredicted;
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null) {
            if (this.m_NumericActual == null) {
                result = "No actual values provided!";
            } else if (this.m_NumericPredicted == null) {
                result = "No predicted values provided!";
            } else if (this.m_NumericActual.length != this.m_NumericPredicted.length) {
                result = "Differing number of actual and predicted values: " + this.m_NumericActual.length + " != " + this.m_NumericPredicted.length;
            }
        }
        return result;
    }
}

