/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.ObjectCopyHelper;
import adams.core.Utils;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.ActualVsPredictedPlot;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.CsvSpreadSheetHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JComponent;

public class ActualVsPredictedHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -5721119391424306170L;
    protected SpreadSheetColumnIndex m_Actual;
    protected SpreadSheetColumnIndex m_Predicted;
    protected SpreadSheetColumnIndex m_Error;
    protected SpreadSheetColumnRange m_Additional;

    public String globalInfo() {
        return "Displays an actual vs predicted plot from the following spreadsheet types:\n" + Utils.flatten((Object[])this.getExtensions(), (String)", ");
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actual", "actual", (Object)new SpreadSheetColumnIndex("Actual"));
        this.m_OptionManager.add("predicted", "predicted", (Object)new SpreadSheetColumnIndex("Predicted"));
        this.m_OptionManager.add("error", "error", (Object)new SpreadSheetColumnIndex(""));
        this.m_OptionManager.add("additional", "additional", (Object)new SpreadSheetColumnRange(""));
    }

    public void setActual(SpreadSheetColumnIndex value) {
        this.m_Actual = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getActual() {
        return this.m_Actual;
    }

    public String actualTipText() {
        return "The column with the actual values.";
    }

    public void setPredicted(SpreadSheetColumnIndex value) {
        this.m_Predicted = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getPredicted() {
        return this.m_Predicted;
    }

    public String predictedTipText() {
        return "The column with the predicted values.";
    }

    public void setError(SpreadSheetColumnIndex value) {
        this.m_Error = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getError() {
        return this.m_Error;
    }

    public String errorTipText() {
        return "The column with the error values.";
    }

    public void setAdditional(SpreadSheetColumnRange value) {
        this.m_Additional = value;
        this.reset();
    }

    public SpreadSheetColumnRange getAdditional() {
        return this.m_Additional;
    }

    public String additionalTipText() {
        return "The additional columns to add to the plot containers.";
    }

    public String[] getExtensions() {
        return new CsvSpreadSheetHandler().getExtensions();
    }

    protected PreviewPanel createPreview(File file) {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        SpreadSheet sheet = reader.read(file);
        ActualVsPredictedPlot plot = new ActualVsPredictedPlot();
        plot.setActual((SpreadSheetColumnIndex)ObjectCopyHelper.copyObject((Object)this.m_Actual));
        plot.setPredicted((SpreadSheetColumnIndex)ObjectCopyHelper.copyObject((Object)this.m_Predicted));
        plot.setError((SpreadSheetColumnIndex)ObjectCopyHelper.copyObject((Object)this.m_Error));
        plot.setAdditional((SpreadSheetColumnRange)ObjectCopyHelper.copyObject((Object)this.m_Additional));
        AbstractDisplayPanel panel = plot.createDisplayPanel(new Token((Object)sheet));
        if (plot.displayPanelRequiresScrollPane()) {
            result.add((Component)new BaseScrollPane((Component)panel), (Object)"Center");
        } else {
            result.add((Component)panel, (Object)"Center");
        }
        return new PreviewPanel((JComponent)result, (JComponent)panel);
    }
}

